/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.engine;

import com.canoo.webtest.boundary.HtmlUnitBoundary;
import com.canoo.webtest.boundary.UrlBoundary;
import com.canoo.webtest.engine.Context;
import com.gargoylesoftware.htmlunit.MockWebConnection;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public final class ContextHelper {
    private static final Logger LOG = Logger.getLogger((Class)ContextHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeResponseFile(WebResponse response, File file) {
        FileOutputStream out = null;
        BufferedInputStream in = null;
        try {
            out = new FileOutputStream(file);
            in = new BufferedInputStream(response.getContentAsStream());
            LOG.debug((Object)("Writing current response in " + file.getName()));
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            File file2;
            try {
                LOG.error((Object)("Failed writing current response to " + file.getName() + ". Ignoring."), (Throwable)e);
                file2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((OutputStream)out);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
            return file2;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defineAsCurrentResponse(Context context, byte[] responseBytes, String contentType, String urlStr) {
        WebClient webClient = context.getWebClient();
        WebConnection originalConnection = webClient.getWebConnection();
        try {
            MockWebConnection mockConnection = new MockWebConnection(webClient);
            webClient.setWebConnection((WebConnection)mockConnection);
            mockConnection.setDefaultResponse(responseBytes, 200, "ok", contentType);
            WebWindow currentTopWindow = context.getCurrentResponse().getEnclosingWindow().getTopWindow();
            if (webClient.getWebWindows().contains(currentTopWindow)) {
                webClient.setCurrentWindow(currentTopWindow);
            }
            URL url = UrlBoundary.tryCreateUrl(urlStr);
            HtmlUnitBoundary.tryGetPage(url, webClient);
        }
        finally {
            webClient.setWebConnection(originalConnection);
        }
    }

    public static void defineAsCurrentResponse(Context context, String responseText, String contentType, String urlStr) {
        ContextHelper.defineAsCurrentResponse(context, responseText.getBytes(), contentType, urlStr);
    }
}

