/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.engine.xpath;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class MatchesFunction
implements Function {
    private static final Logger LOG = Logger.getLogger((Class)MatchesFunction.class);

    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() < 2 || args.size() > 3) {
            throw new FunctionCallException("function requires 2 or 3 arguments!");
        }
        Navigator navigator = context.getNavigator();
        String input = StringFunction.evaluate(args.get(0), (Navigator)navigator);
        String regex = StringFunction.evaluate(args.get(1), (Navigator)navigator);
        LOG.debug((Object)("input: " + input));
        int flags = args.size() == 2 ? 0 : MatchesFunction.computeFlags(StringFunction.evaluate(args.get(2), (Navigator)navigator));
        Pattern pattern = Pattern.compile(regex, flags);
        Matcher matcher = pattern.matcher(input);
        boolean rep = matcher.find();
        return rep;
    }

    static int computeFlags(String flags) throws FunctionCallException {
        char c;
        int flag = 0;
        block6: for (int i = 0; i < flags.length() && flags.indexOf(c = flags.charAt(i)) == i; ++i) {
            switch (c) {
                case 's': {
                    flag += 32;
                    continue block6;
                }
                case 'm': {
                    flag += 8;
                    continue block6;
                }
                case 'i': {
                    flag += 2;
                    continue block6;
                }
                case 'x': {
                    flag += 4;
                    continue block6;
                }
                default: {
                    throw new FunctionCallException("Illegal flag used for call to matches: " + c);
                }
            }
        }
        return flag;
    }
}

