/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.engine.xpath;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.engine.xpath.CleanTextFunction;
import com.canoo.webtest.engine.xpath.MatchesFunction;
import com.canoo.webtest.engine.xpath.MemberKey;
import com.canoo.webtest.engine.xpath.XPathWithoutDocument;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitXPath;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jaxen.Function;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleFunctionContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.XPathFunctionContext;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XPathHelper {
    private SimpleVariableContext fVariableContext = new SimpleVariableContext();
    private SimpleFunctionContext fFunctionContext = new XPathFunctionContext();
    private SimpleNamespaceContext fNamespaceContext = new SimpleNamespaceContext();
    private static Map sGlobalVariables = Collections.synchronizedMap(new HashMap());
    private static Map sGlobalFunctions = Collections.synchronizedMap(new HashMap());
    private static Map sGlobalNamespaces = Collections.synchronizedMap(new HashMap());

    public static void registerGlobalVariable(String namespaceURI, String localName, Object value) {
        sGlobalVariables.put(new MemberKey(namespaceURI, localName), value);
    }

    private static void registerWebTestGoodies() {
        String namespaceURI = "http://webtest.canoo.com";
        XPathHelper.registerGlobalNamespace("wt", "http://webtest.canoo.com");
        XPathHelper.registerGlobalFunction("http://webtest.canoo.com", "matches", new MatchesFunction());
        XPathHelper.registerGlobalFunction("http://webtest.canoo.com", "cleanText", new CleanTextFunction());
    }

    public static Map getGlobalVariables() {
        return sGlobalVariables;
    }

    public static Map getGlobalFunctions() {
        return sGlobalFunctions;
    }

    public static Map getGlobalNamespaces() {
        return sGlobalNamespaces;
    }

    public static void registerGlobalFunction(String namespaceURI, String localName, Function function) {
        sGlobalFunctions.put(new MemberKey(namespaceURI, localName), function);
    }

    public static void registerGlobalNamespace(String prefix, String namespaceURI) {
        sGlobalNamespaces.put(prefix, namespaceURI);
    }

    public XPathHelper() {
        MemberKey memberKey;
        Map.Entry entry;
        Iterator iter = XPathHelper.getGlobalNamespaces().entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            this.getNamespaceContext().addNamespace((String)entry.getKey(), (String)entry.getValue());
        }
        iter = XPathHelper.getGlobalFunctions().entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            memberKey = (MemberKey)entry.getKey();
            this.getFunctionContext().registerFunction(memberKey.getNamespaceURI(), memberKey.getLocalName(), (Function)entry.getValue());
        }
        iter = XPathHelper.getGlobalVariables().entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            memberKey = (MemberKey)entry.getKey();
            this.getVariableContext().setVariableValue(memberKey.getNamespaceURI(), memberKey.getLocalName(), entry.getValue());
        }
    }

    public SimpleFunctionContext getFunctionContext() {
        return this.fFunctionContext;
    }

    public SimpleNamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    public SimpleVariableContext getVariableContext() {
        return this.fVariableContext;
    }

    public XPath getXPath(Page page, String xpathExpr) throws JaxenException {
        XPath xpath = this.buildXPath(page, xpathExpr);
        if (!(page instanceof XmlPage)) {
            xpath.setNamespaceContext((NamespaceContext)this.fNamespaceContext);
        }
        xpath.setVariableContext((VariableContext)this.fVariableContext);
        xpath.setFunctionContext((FunctionContext)this.fFunctionContext);
        return xpath;
    }

    public Object getDocument(Page page) {
        if (page == null) {
            return null;
        }
        if (page instanceof HtmlPage) {
            return page;
        }
        if (page instanceof XmlPage) {
            XmlPage xmlPage = (XmlPage)page;
            if (xmlPage.getXmlDocument() == null) {
                throw new StepFailedException("The xml document couldn't be parsed as it is not well formed");
            }
            return xmlPage.getXmlDocument();
        }
        throw this.buildInvalidDocumentException(page);
    }

    protected XPath buildXPath(Page page, String xpathExpr) throws JaxenException {
        if (page == null) {
            return new XPathWithoutDocument(xpathExpr);
        }
        if (page instanceof HtmlPage) {
            return new HtmlUnitXPath(xpathExpr);
        }
        if (page instanceof XmlPage) {
            XmlPage xmlPage = (XmlPage)page;
            if (xmlPage.getXmlDocument() == null) {
                throw new StepFailedException("The xml document couldn't be parsed as it is not well formed");
            }
            DOMXPath xpath = new DOMXPath(xpathExpr);
            SimpleLocalNamespaceContext nsContext = new SimpleLocalNamespaceContext((NamespaceContext)this.getNamespaceContext());
            xpath.setNamespaceContext((NamespaceContext)nsContext);
            NamedNodeMap docEltAttributes = xmlPage.getXmlDocument().getDocumentElement().getAttributes();
            for (int i = 0; i < docEltAttributes.getLength(); ++i) {
                Node attrNode = docEltAttributes.item(i);
                if (!attrNode.getNodeName().startsWith("xmlns:")) continue;
                String namespace = attrNode.getNodeName().substring(6);
                nsContext.addNamespace(namespace, attrNode.getNodeValue());
            }
            return xpath;
        }
        throw this.buildInvalidDocumentException(page);
    }

    StepFailedException buildInvalidDocumentException(Page page) {
        return new StepFailedException("Current response is not an HTML or XML page but of type " + page.getWebResponse().getContentType() + " (" + page.getClass().getName() + ")");
    }

    static {
        XPathHelper.registerWebTestGoodies();
    }

    private static class SimpleLocalNamespaceContext
    extends SimpleNamespaceContext {
        private final NamespaceContext fWrappedContext;

        SimpleLocalNamespaceContext(NamespaceContext _wrapped) {
            this.fWrappedContext = _wrapped;
        }

        public String translateNamespacePrefixToUri(String prefix) {
            String resp = super.translateNamespacePrefixToUri(prefix);
            if (resp == null) {
                return this.fWrappedContext.translateNamespacePrefixToUri(prefix);
            }
            return resp;
        }
    }
}

