/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.steps.AbstractFilter;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentStripperFilter
extends AbstractFilter {
    private static final Logger LOG = Logger.getLogger((Class)ContentStripperFilter.class);

    public void doExecute() throws Exception {
        Page currentResponse = this.getContext().getCurrentResponse();
        String origType = currentResponse.getWebResponse().getContentType();
        LOG.info((Object)("Filtering response of type " + origType));
        StringBuffer buf = new StringBuffer();
        if (currentResponse instanceof HtmlPage) {
            HtmlPage page = (HtmlPage)currentResponse;
            buf.append("<html>");
            ContentStripperFilter.processHtml(page.getDocumentHtmlElement().getChildIterator(), buf);
            buf.append("</html>");
        } else if (currentResponse instanceof XmlPage) {
            XmlPage page = (XmlPage)currentResponse;
            Document xmlDocument = page.getXmlDocument();
            if (xmlDocument != null) {
                ContentStripperFilter.processXml(xmlDocument.getChildNodes().item(0), buf);
            }
        } else {
            LOG.warn((Object)("Unexpected current response: " + origType + ", filter result will be empty"));
        }
        this.defineAsCurrentResponse(buf.toString(), origType);
    }

    private static void processHtml(Iterator children, StringBuffer buf) {
        while (children.hasNext()) {
            DomNode node = (DomNode)children.next();
            if (node instanceof DomText) continue;
            buf.append("<").append(node.getNodeName()).append(">");
            ContentStripperFilter.processHtml(node.getChildIterator(), buf);
            buf.append("</").append(node.getNodeName()).append(">");
        }
    }

    private static void processXml(Node node, StringBuffer buf) {
        buf.append("<").append(node.getNodeName()).append(">");
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!n.hasChildNodes()) continue;
            ContentStripperFilter.processXml(n, buf);
        }
        buf.append("</").append(node.getNodeName()).append(">");
    }
}

