/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.steps.AbstractFilter;
import com.canoo.webtest.util.ConversionUtil;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MatchLinesFilter
extends AbstractFilter {
    private static final String LS = System.getProperty("line.separator");
    private String fRegex;
    private String fRemove;

    public void setRegex(String value) {
        this.fRegex = value;
    }

    public String getRegex() {
        return this.fRegex;
    }

    public void setRemove(String flag) {
        this.fRemove = flag;
    }

    public String getRemove() {
        return this.fRemove;
    }

    public void doExecute() throws Exception {
        WebResponse webResponse = this.getContext().getCurrentResponse().getWebResponse();
        String orig = webResponse.getContentAsString();
        String origType = webResponse.getContentType();
        boolean remove = ConversionUtil.convertToBoolean(this.getRemove(), false);
        String lineStr = "(^.*$)";
        Pattern linePattern = Pattern.compile("(^.*$)", 8);
        Matcher matcher = linePattern.matcher(orig);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String line = matcher.group(0);
            if (line.matches(this.fRegex) == remove) continue;
            buf.append(line).append(LS);
        }
        this.defineAsCurrentResponse(buf.toString(), origType);
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getRegex(), "regex");
        this.nullResponseCheck();
    }
}

