/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.steps.store.BaseStoreStep;
import com.canoo.webtest.util.ConversionUtil;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public final class StoreRandom
extends BaseStoreStep {
    private static final Logger LOG = Logger.getLogger((Class)StoreRandom.class);
    private static final int MODE_NUMBER = 1;
    private static final int MODE_STRING = 2;
    private static final int MODE_CHOICE = 3;
    private static final String DEFAULT_CHARS = " abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789 ";
    private String fFrom;
    private String fTo;
    private String fLength;
    private String fChars;
    private String fChoice;
    private int fMode;

    public String getFrom() {
        return this.fFrom;
    }

    public void setFrom(String from) {
        this.fFrom = from;
    }

    public String getTo() {
        return this.fTo;
    }

    public void setTo(String to) {
        this.fTo = to;
    }

    public String getLength() {
        return this.fLength;
    }

    public void setLength(String length) {
        this.fLength = length;
    }

    public String getChars() {
        return this.fChars;
    }

    public void setChars(String chars) {
        this.fChars = chars;
    }

    public String getChoice() {
        return this.fChoice;
    }

    public void setChoice(String choice) {
        this.fChoice = choice;
    }

    public void doExecute() {
        String randString;
        switch (this.fMode) {
            case 1: {
                int fromInt = ConversionUtil.convertToInt(this.getFrom(), -1);
                int toInt = ConversionUtil.convertToInt(this.getTo(), -1);
                this.paramCheck(fromInt >= toInt, "Parameter \"from\" must be less than parameter \"to\"!");
                randString = StoreRandom.generateRandomNumber(fromInt, toInt);
                break;
            }
            case 3: {
                StringTokenizer st = new StringTokenizer(this.getChoice(), ",");
                this.paramCheck(st.countTokens() < 1, "Parameter \"choice\" must have some comma-delimited choices!");
                randString = StoreRandom.generateRandomToken(st);
                break;
            }
            default: {
                int numChars = ConversionUtil.convertToInt(this.getLength(), 0);
                randString = this.getChars() == null ? StoreRandom.generateRandomChars(numChars, DEFAULT_CHARS) : StoreRandom.generateRandomChars(numChars, this.getChars());
            }
        }
        this.storeProperty(randString);
    }

    private static String generateRandomToken(StringTokenizer st) {
        String randString = "";
        int pos = (int)(Math.random() * (double)st.countTokens()) + 1;
        while (pos-- > 0) {
            randString = st.nextToken();
        }
        return randString;
    }

    private static String generateRandomNumber(int fromInt, int toInt) {
        int randValue = fromInt + (int)(Math.random() * (double)(toInt - fromInt + 1));
        return Integer.toString(randValue);
    }

    private static String generateRandomChars(int numChars, String chars) {
        StringBuffer randBuf = new StringBuffer();
        int l = chars.length();
        for (int i = 0; i < numChars; ++i) {
            int pos = (int)((double)l * Math.random());
            randBuf.append(chars.charAt(pos));
        }
        return randBuf.toString();
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getProperty(), "property");
        this.fMode = 0;
        if (this.isOnlyLengthSet()) {
            this.fMode = 2;
            this.integerParamCheck(this.getLength(), "length", true);
            LOG.debug((Object)"Mode = MODE_STRING");
        } else if (this.isOnlyFromAndToSet()) {
            this.fMode = 1;
            this.integerParamCheck(this.getFrom(), "from", true);
            this.integerParamCheck(this.getTo(), "to", true);
            LOG.debug((Object)"Mode = MODE_NUMBER");
        } else if (this.isOnlyChoiceSet()) {
            this.fMode = 3;
            LOG.debug((Object)"Mode = MODE_CHOICE");
        }
        this.paramCheck(this.fMode == 0, "Required parameter(s) not set correctly! Need (\"from\" and \"to\") or \"length\" or \"choice\".");
    }

    private boolean isOnlyChoiceSet() {
        return this.getChoice() != null && this.getLength() == null && this.getFrom() == null && this.getTo() == null;
    }

    private boolean isOnlyFromAndToSet() {
        return this.getFrom() != null && this.getTo() != null && this.getChoice() == null && this.getLength() == null;
    }

    private boolean isOnlyLengthSet() {
        return this.getFrom() == null && this.getTo() == null && this.getChoice() == null && this.getLength() != null;
    }
}

