/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.applet;

import com.canoo.webtest.ant.WebtestTask;
import com.canoo.webtest.boundary.AppletRunnerStepBoundary;
import com.canoo.webtest.boundary.UrlBoundary;
import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.extension.applet.AbstractAppletTag;
import com.canoo.webtest.extension.applet.AppletPluginArguments;
import com.canoo.webtest.extension.applet.AppletPluginResults;
import com.canoo.webtest.extension.applet.Parameter;
import com.canoo.webtest.extension.applet.ParameterRef;
import com.canoo.webtest.extension.applet.ParameterSet;
import com.canoo.webtest.extension.applet.runner.AppletRunner;
import com.canoo.webtest.steps.request.AbstractTargetAction;
import com.canoo.webtest.steps.store.StoreCookie;
import com.canoo.webtest.util.FileUtil;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.Loader;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.netbeans.jemmy.Scenario;
import org.xml.sax.SAXException;

public class AppletRunnerStep
extends AbstractTargetAction {
    private static final Logger LOG = Logger.getLogger((Class)AppletRunnerStep.class);
    public static final String PROTOCOL_HANDLER_LIST = "java.protocol.handler.pkgs";
    public static final String RUNNER_PACKAGE = "com.canoo.webtest.extension.applet.runner";
    public static final String A_CLOVER_CLASS = "com.cenqua.clover.CloverInstr";
    static final String LOG4J_DEFAULT_INIT_OVERRIDES = "log4j.defaultInitOverride";
    static final String LOG4J_CONFIGURATION = "log4j.configuration";
    static final Integer ZERO = new Integer(0);
    private String fTarget;
    private String fXPath;
    private String fScenario;
    private String fScenarioLocation;
    private final Path fScenarioLocationPath = new Path(null);
    private final ParameterSet fParameters = new ParameterSet();
    private final CommandlineJava fCommandline = new CommandlineJava();

    public AppletRunnerStep() {
        AppletRunnerStep.setupLog4j(this.fCommandline);
        this.setupClasspath(this.fCommandline);
    }

    public String getScenarioLocation() {
        return this.fScenarioLocation;
    }

    public void setScenarioLocation(String scenarioLocation) {
        this.fScenarioLocation = scenarioLocation;
    }

    public String getScenario() {
        return this.fScenario;
    }

    public void setScenario(String scenario) {
        this.fScenario = scenario;
    }

    public void setXpath(String xpath) {
        this.fXPath = xpath;
    }

    public String getXpath() {
        return this.fXPath;
    }

    public String getTarget() {
        return this.fTarget;
    }

    public void setTarget(String target) {
        this.fTarget = target;
    }

    public void setProject(Project p) {
        super.setProject(p);
        this.fScenarioLocationPath.setProject(this.getProject());
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.fXPath, "xpath");
        this.nullParamCheck(this.fScenario, "scenario");
        if (this.fScenarioLocation != null) {
            this.fScenarioLocationPath.addExisting(new Path(this.getProject(), this.fScenarioLocation));
        }
        this.nullResponseCheck();
    }

    protected void addComputedParameters(Map map) {
        Iterator iterator = this.fParameters.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof Parameter) {
                Parameter param = (Parameter)obj;
                map.put(param.getName(), param.getValue());
                continue;
            }
            ParameterRef paramRef = (ParameterRef)obj;
            map.put(paramRef.getRegex(), paramRef.getPropertyType());
        }
    }

    public void addParam(Parameter param) {
        this.addParameter(param);
    }

    public void addParameter(Parameter param) {
        this.fParameters.add(param);
    }

    public void addParameterRef(ParameterRef param) {
        this.fParameters.add(param);
    }

    Iterator getParameters() {
        return this.fParameters.iterator();
    }

    protected Page findTarget() throws JaxenException, IOException, SAXException {
        this.fParameters.expandProperties(this);
        AppletPluginArguments appletPluginArguments = this.setUpAppletPluginArguments();
        AppletPluginResults apr = this.runApplet(appletPluginArguments);
        return this.findTargetWithResults(apr, this.getContext());
    }

    protected String getLogMessageForTarget() {
        return "by applet showDocument";
    }

    protected Page findTargetWithResults(AppletPluginResults apr, Context context) throws IOException, SAXException {
        if (this.fTarget != null) {
            Map allFrames = apr.getFrames();
            if (allFrames.containsKey(this.fTarget)) {
                URL url = (URL)allFrames.get(this.fTarget);
                return this.getResponse(new WebRequestSettings(url));
            }
            Iterator frames = allFrames.entrySet().iterator();
            while (frames.hasNext()) {
                Map.Entry frame = frames.next();
                LOG.error((Object)(frame.getKey() + " -> " + ((URL)frame.getValue()).toExternalForm()));
            }
            throw new StepFailedException("The applet didn't showDocument in " + this.fTarget);
        }
        return null;
    }

    private AppletPluginResults readResults(AppletPluginArguments appletPluginArguments) {
        return (AppletPluginResults)FileUtil.tryReadObjectFromFile(appletPluginArguments.getOutputFile(), this);
    }

    private AppletPluginArguments setUpAppletPluginArguments() {
        HtmlElement appletNode;
        HtmlPage currentResponse = this.getContext().getCurrentHtmlResponse(this);
        try {
            XPath xpath = this.getContext().getXPathHelper().getXPath((Page)currentResponse, this.getXpath());
            appletNode = (HtmlElement)xpath.selectSingleNode((Object)currentResponse);
        }
        catch (JaxenException e) {
            String msg = "Xpath error for '" + this.getXpath() + "'";
            LOG.error((Object)msg, (Throwable)e);
            throw new StepExecutionException(msg + " " + e.getMessage(), this);
        }
        if (appletNode == null) {
            throw new StepFailedException("The specified element <" + this.getXpath() + "> was not found.", this);
        }
        AppletPluginArguments appletPluginArguments = this.createAppletPluginArguments();
        appletPluginArguments.setAppletTag(this.extractAppletParameter(currentResponse.getWebResponse().getUrl(), appletNode));
        return appletPluginArguments;
    }

    AppletPluginArguments createAppletPluginArguments() {
        WebtestTask webtest = this.getContext().getWebtest();
        AppletPluginArguments appletPluginArguments = new AppletPluginArguments();
        StringBuffer sb = new StringBuffer(webtest.getName());
        sb.append(this.getDescription(" - ", ""));
        appletPluginArguments.setBaseWindowName(sb.toString());
        appletPluginArguments.setSaveResponse(webtest.getConfig().isSaveResponse());
        appletPluginArguments.setSaveDirectory(webtest.getConfig().getWebTestResultDir());
        appletPluginArguments.setOutputFile(this.createTempFile(".output"));
        appletPluginArguments.setScenarioLocation(this.convertPathToURL(this.fScenarioLocationPath));
        appletPluginArguments.setScenario(this.fScenario);
        Iterator iterator = this.getParameters();
        while (iterator.hasNext()) {
            appletPluginArguments.addArgument((Parameter)iterator.next());
        }
        appletPluginArguments.addCookies(StoreCookie.getCookies(this.getContext()));
        return appletPluginArguments;
    }

    protected URL[] convertPathToURL(Path path) {
        if (path == null) {
            return AppletPluginArguments.EMPTY_URL_LIST;
        }
        String[] pathElements = path.list();
        URL[] urls = new URL[pathElements.length];
        for (int i = 0; i < pathElements.length; ++i) {
            urls[i] = UrlBoundary.tryCreateUrlFromFileWithError(new File(pathElements[i]), this);
        }
        return urls;
    }

    AbstractAppletTag extractAppletParameter(URL url, HtmlElement appletNode) {
        try {
            return AbstractAppletTag.newInstance(url, appletNode);
        }
        catch (Exception e) {
            throw new StepFailedException(e.getMessage(), this);
        }
    }

    private AppletPluginResults runApplet(AppletPluginArguments appletPluginArguments) {
        int exitValue = this.executeAsForked(appletPluginArguments);
        LOG.info((Object)("runApplet: exitValue was: " + exitValue));
        if (exitValue != 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("Test ").append(this.fScenario).append(" failed. Exit value: ").append(exitValue);
            String s = msg.toString();
            LOG.error((Object)s);
            throw new StepExecutionException(s, this);
        }
        AppletPluginResults apr = this.readResults(appletPluginArguments);
        this.verifyAppletResult(apr);
        Iterator properties = apr.getProperties().iterator();
        while (properties.hasNext()) {
            AppletPluginResults.Property property = (AppletPluginResults.Property)properties.next();
            this.setWebtestProperty(property.getName(), property.getValue(), property.getType());
        }
        return apr;
    }

    void verifyAppletResult(AppletPluginResults apr) {
        if (apr.getException() != null) {
            throw new StepFailedException(apr.getException(), this);
        }
        if (apr.getJemmyException() != null) {
            throw new StepFailedException(apr.getJemmyException(), this);
        }
        if (!ZERO.equals(apr.getReturnValue())) {
            throw new StepFailedException("Scenario returns " + apr.getReturnValue(), this);
        }
    }

    private int executeAsForked(AppletPluginArguments appletPluginArguments) {
        CommandlineJava cmd = AppletRunnerStepBoundary.tryClone(this.fCommandline, this);
        cmd.setClassname(AppletRunner.class.getName());
        cmd.addSysproperty(AppletRunnerStep.getProtocolHandler());
        cmd.createArgument().setValue(this.writeArguments(appletPluginArguments));
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1));
        execute.setCommandline(cmd.getCommandline());
        execute.setAntRun(this.getProject());
        LOG.info((Object)cmd.describeCommand());
        return AppletRunnerStepBoundary.tryExecute(execute, this);
    }

    static Environment.Variable getProtocolHandler() {
        Environment.Variable sysp = new Environment.Variable();
        sysp.setKey(PROTOCOL_HANDLER_LIST);
        String handlers = System.getProperty(PROTOCOL_HANDLER_LIST, "");
        sysp.setValue(RUNNER_PACKAGE + (handlers.length() == 0 ? "" : "|" + handlers));
        return sysp;
    }

    private void setupClasspath(CommandlineJava cmd) {
        Path classpath = cmd.createClasspath(this.getProject());
        this.appendToClasspath(LogFactory.class, classpath);
        this.appendToClasspath(HostConfiguration.class, classpath);
        this.appendToClasspath(Logger.class, classpath);
        this.appendToClasspath(Commandline.Argument.class, classpath);
        this.appendToClasspath(HtmlElement.class, classpath);
        this.appendToClasspath(DecoderException.class, classpath);
        this.appendOptionalToClasspath(A_CLOVER_CLASS, classpath);
        this.appendToClasspath(Scenario.class, classpath);
        this.appendToClasspath(AppletRunner.class, classpath);
    }

    static void setupLog4j(CommandlineJava cmd) {
        String log4jDefaultInitOverride = System.getProperty(LOG4J_DEFAULT_INIT_OVERRIDES, "false");
        if ("false".equals(log4jDefaultInitOverride)) {
            URL resourceURL;
            String resource = System.getProperty(LOG4J_CONFIGURATION, "log4j.properties");
            try {
                resourceURL = new URL(resource);
            }
            catch (MalformedURLException e) {
                resourceURL = Loader.getResource((String)resource);
            }
            if (resourceURL == null) {
                log4jDefaultInitOverride = "true";
            } else {
                AppletRunnerStep.setSysProperty(cmd, LOG4J_CONFIGURATION, resourceURL.toExternalForm());
            }
        }
        AppletRunnerStep.setSysProperty(cmd, LOG4J_DEFAULT_INIT_OVERRIDES, log4jDefaultInitOverride);
    }

    static void setSysProperty(CommandlineJava cmd, String key, String value) {
        Environment.Variable sysp = new Environment.Variable();
        sysp.setKey(key);
        sysp.setValue(value);
        cmd.addSysproperty(sysp);
    }

    void appendToClasspath(Class aClass, Path classpath) {
        if (!this.appendOptionalToClasspath(aClass.getName(), classpath)) {
            String msg = "Can't locate required class " + aClass.getName();
            LOG.error((Object)msg);
            throw new StepFailedException(msg, this);
        }
    }

    boolean appendOptionalToClasspath(String aClassName, Path classpath) {
        URL url = AppletRunnerStepBoundary.tryGetUrlForClass(aClassName, this);
        if (url == null) {
            LOG.warn((Object)("Can't locate optional class " + aClassName));
            return false;
        }
        classpath.createPathElement().setLocation(new File(url.getFile()));
        return true;
    }

    private String writeArguments(AppletPluginArguments apa) {
        File tmpFile = this.createTempFile(".arguments");
        FileUtil.tryWriteObjectToFile(tmpFile, apa, this);
        return tmpFile.getAbsolutePath();
    }

    private File createTempFile(String suffix) {
        return FileUtil.tryCreateTempFile("AppletPlugin", suffix, this);
    }

    public static URL getUrlForClass(String className) throws MalformedURLException {
        LOG.debug((Object)("Looking for " + className));
        String classRsrc = className.replace('.', '/') + ".class";
        URL resource = AppletRunnerStep.class.getClassLoader().getResource(classRsrc);
        if (resource == null) {
            return null;
        }
        return new URL(resource, AppletRunnerStep.extractClasspathEntry(resource.getFile(), classRsrc));
    }

    static String extractClasspathEntry(String url, String classRsrc) {
        int length = url.length() - classRsrc.length();
        if ("!/".equals(url.substring(length - 2, length))) {
            length -= 2;
        }
        return url.substring(0, length);
    }

    public Commandline.Argument createJvmarg() {
        return this.fCommandline.createVmArgument();
    }
}

