/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.applet.runner.https;

import com.canoo.webtest.engine.Configuration;
import com.canoo.webtest.extension.applet.runner.http.HttpURLConnection;
import com.canoo.webtest.interfaces.IConnectionInitializer;
import com.canoo.webtest.interfaces.IPropertyHandler;
import com.canoo.webtest.security.ConnectionInitializationException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.log4j.Logger;

public class Handler
extends URLStreamHandler {
    private static final Logger LOG = Logger.getLogger((Class)Handler.class);
    private static boolean sAlreadyInitialized;
    private static Configuration sConfig;
    public static final IPropertyHandler SYSTEM_PROPERTY_HANDLER;

    public static boolean isAlreadyInitialized() {
        return sAlreadyInitialized;
    }

    static void initializeCustomConnectionInitializer() {
        if (sAlreadyInitialized) {
            return;
        }
        sAlreadyInitialized = true;
        String customInitializerClassName = sConfig.getExternalProperty("webtest.connectioninitializer");
        if (customInitializerClassName == null) {
            return;
        }
        Handler.allocateAndInit(customInitializerClassName);
    }

    static void allocateAndInit(String customInitializerClassName) {
        IConnectionInitializer customInitializer;
        try {
            customInitializer = (IConnectionInitializer)Class.forName(customInitializerClassName).newInstance();
        }
        catch (Exception e) {
            LOG.info((Object)("exception instantiating Connection Initializer " + e.getMessage()), (Throwable)e);
            throw (RuntimeException)e;
        }
        try {
            customInitializer.initializeConnection(sConfig);
            LOG.info((Object)"custom connection initializer set-up.");
        }
        catch (ConnectionInitializationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected int getDefaultPort() {
        return 443;
    }

    protected URLConnection openConnection(URL url) throws IOException {
        Handler.initializeCustomConnectionInitializer();
        return new HttpURLConnection(url);
    }

    static {
        SYSTEM_PROPERTY_HANDLER = new IPropertyHandler(){

            public String getProperty(String propertyName) {
                return System.getProperty(propertyName);
            }
        };
        sConfig = new Configuration();
        sConfig.setPropertyHandler(SYSTEM_PROPERTY_HANDLER);
        sConfig.setProtocol("https");
    }
}

