/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.spider;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.extension.spider.IValidator;
import com.canoo.webtest.interfaces.IStepSequence;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.Iterator;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ExecuteStepValidator
implements IValidator {
    private final IStepSequence fStepSequence;
    public static final String KEY_DEPTH = "Depth";
    public static final String KEY_VERIFY = "Verify";

    public ExecuteStepValidator(Context context, IStepSequence stepSequence) {
        this.fStepSequence = stepSequence;
    }

    public Properties validate(int depth, HtmlPage htmlPage, HtmlAnchor link) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        Iterator iter = this.fStepSequence.getSteps().iterator();
        while (iter.hasNext()) {
            Task step = (Task)iter.next();
            sb.append(i++);
            sb.append(", ");
            sb.append(this.getDescription(step));
            sb.append(": ");
            try {
                step.perform();
                sb.append("ok");
            }
            catch (BuildException e) {
                sb.append(e.getMessage());
            }
            sb.append("\t");
        }
        Properties linkInfo = new Properties();
        linkInfo.put(KEY_DEPTH, Integer.toString(depth));
        linkInfo.put(KEY_VERIFY, sb.toString());
        return linkInfo;
    }

    private String getDescription(Task step) {
        return (String)step.getRuntimeConfigurableWrapper().getAttributeMap().get("description");
    }
}

