/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.spider;

import com.canoo.webtest.extension.spider.IReporter;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;

public class SeparatedValueReporter
implements IReporter {
    public static final String VALUE_SEPARATOR = "\t";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final String[] fHeaders;
    private Writer fWriter;

    public SeparatedValueReporter(String[] headers) {
        if (headers == null) {
            throw new IllegalArgumentException("Headers must be defined");
        }
        this.fHeaders = headers;
    }

    public void setWriter(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("Writer must be defined");
        }
        this.fWriter = writer;
    }

    public void writeHeader() throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.fHeaders.length; ++i) {
            sb.append(this.fHeaders[i]).append(VALUE_SEPARATOR);
        }
        this.fWriter.write(SeparatedValueReporter.finishLine(sb));
    }

    public void write(Properties linkInfo) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.fHeaders.length; ++i) {
            sb.append(linkInfo.getProperty(this.fHeaders[i], "")).append(VALUE_SEPARATOR);
        }
        this.fWriter.write(SeparatedValueReporter.finishLine(sb));
    }

    public void writeFooter() {
    }

    static String finishLine(StringBuffer sb) {
        if (sb.length() > 0) {
            sb.setLength(sb.length() - VALUE_SEPARATOR.length());
        }
        sb.append(LINE_SEPARATOR);
        return sb.toString();
    }
}

