/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.emailtest;

import com.canoo.webtest.plugins.emailtest.AbstractStoreStep;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSelectStep
extends AbstractStoreStep {
    private String fSubject;
    private String fFrom;
    private String fTo;
    private String fCc;
    private String fReplyTo;

    public void setSubject(String value) {
        this.fSubject = value;
    }

    public String getSubject() {
        return this.fSubject;
    }

    public void setFrom(String value) {
        this.fFrom = value;
    }

    public String getFrom() {
        return this.fFrom;
    }

    public void setTo(String value) {
        this.fTo = value;
    }

    public String getTo() {
        return this.fTo;
    }

    public void setCc(String value) {
        this.fCc = value;
    }

    public String getCc() {
        return this.fCc;
    }

    public void setReplyTo(String value) {
        this.fReplyTo = value;
    }

    public String getReplyTo() {
        return this.fReplyTo;
    }

    protected Message[] retrieveMatchingMessages(Folder folder) throws MessagingException {
        Message[] messages = this.getHelper().getMessages(folder);
        if (this.noMatchCriteria()) {
            return messages;
        }
        ArrayList<Message> result = new ArrayList<Message>();
        for (int message = 0; message < messages.length; ++message) {
            if (!this.messageMatches(messages[message])) continue;
            result.add(messages[message]);
        }
        return result.toArray(new Message[0]);
    }

    private boolean noMatchCriteria() {
        return StringUtils.isEmpty((String)this.getSubject()) && StringUtils.isEmpty((String)this.getFrom()) && StringUtils.isEmpty((String)this.getTo()) && StringUtils.isEmpty((String)this.getCc()) && StringUtils.isEmpty((String)this.getReplyTo());
    }

    boolean messageMatches(Message message) throws MessagingException {
        if (!AbstractSelectStep.doMatch(this.getFrom(), message.getFrom()[0].toString())) {
            return false;
        }
        if (!AbstractSelectStep.doMatch(this.getSubject(), message.getSubject())) {
            return false;
        }
        if (!AbstractSelectStep.doMatchMultiple(this.getReplyTo(), message.getReplyTo())) {
            return false;
        }
        if (!AbstractSelectStep.doMatchMultiple(this.getCc(), message.getRecipients(MimeMessage.RecipientType.CC))) {
            return false;
        }
        return AbstractSelectStep.doMatchMultiple(this.getTo(), message.getRecipients(MimeMessage.RecipientType.TO));
    }

    static boolean doMatch(String expected, String actual) {
        actual = StringUtils.defaultString((String)actual, (String)"");
        if (StringUtils.isEmpty((String)expected)) {
            return true;
        }
        if (AbstractSelectStep.isRegexMatch(expected)) {
            return AbstractSelectStep.getVerifier(true).verifyStrings(expected.substring(1, expected.length() - 1), actual);
        }
        return AbstractSelectStep.getVerifier(false).verifyStrings(expected, actual);
    }

    static boolean doMatchMultiple(String expected, Address[] actuals) {
        if (StringUtils.isEmpty((String)expected)) {
            return true;
        }
        StringTokenizer expectedTokens = new StringTokenizer(expected, ",");
        while (expectedTokens.hasMoreTokens()) {
            Address actual;
            String expectedToken = expectedTokens.nextToken().trim();
            boolean hasMatched = false;
            for (int i = 0; i < actuals.length && !(hasMatched = AbstractSelectStep.doMatch(expectedToken, (actual = actuals[i]).toString())); ++i) {
            }
            if (hasMatched) continue;
            return false;
        }
        return true;
    }

    protected static boolean isRegexMatch(String expected) {
        return expected.startsWith("/") && expected.endsWith("/") && expected.length() > 1;
    }
}

