/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.exceltest;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.plugins.exceltest.AbstractExcelStep;
import org.apache.poi.hssf.usermodel.HSSFSheet;

public abstract class AbstractExcelSheetStep
extends AbstractExcelStep {
    private String fSheetName;
    private String fSheetIndex;

    protected void setCurrentSheet(HSSFSheet sheet) {
        this.getContext().put(KEY_CURRENT_SHEET, sheet);
    }

    protected HSSFSheet getExcelSheet() {
        int numberOfSheets = this.getExcelWorkbook().getNumberOfSheets();
        if (numberOfSheets == 0) {
            throw new StepExecutionException("This spreadsheet has no sheets", this);
        }
        HSSFSheet sheet = null;
        if (this.fSheetName != null && (sheet = this.getExcelWorkbook().getSheet(this.fSheetName)) == null) {
            throw new StepExecutionException("A sheet named '" + this.fSheetName + "' was not found in the file.", this);
        }
        if (sheet == null && this.fSheetIndex != null) {
            int sheetIndex = Integer.parseInt(this.fSheetIndex);
            if (sheetIndex < 0 || sheetIndex >= numberOfSheets) {
                throw new StepExecutionException("Invalid sheet index: " + this.fSheetIndex + ". This workbook contains sheets with indexes from 0 to " + (numberOfSheets - 1) + ".", this);
            }
            sheet = this.getExcelWorkbook().getSheetAt(sheetIndex);
        }
        if (sheet == null) {
            sheet = (HSSFSheet)this.getContext().get(KEY_CURRENT_SHEET);
        }
        if (sheet == null) {
            sheet = this.getExcelWorkbook().getSheetAt(0);
        }
        return sheet;
    }

    public void setSheetName(String name) {
        this.fSheetName = name;
    }

    public String getSheetName() {
        return this.fSheetName;
    }

    public void setSheetIndex(String index) {
        this.fSheetIndex = index;
    }

    public String getSheetIndex() {
        return this.fSheetIndex;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.optionalIntegerParamCheck(this.fSheetIndex, "sheetIndex", true);
    }
}

