/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.pdftest.AbstractVerifyPdfStep;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFEncryptionPermission;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PdfVerifyEncryptionPermissionsStep
extends AbstractVerifyPdfStep {
    private String fAllow;
    private String fDeny;
    private final List fAllowPermissions = new ArrayList();
    private final List fDenyPermissions = new ArrayList();

    public void setAllow(String allow) {
        this.fAllow = allow;
    }

    public String getAllow() {
        return this.fAllow;
    }

    public void setDeny(String deny) {
        this.fDeny = deny;
    }

    public String getDeny() {
        return this.fDeny;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.paramCheck(this.getAllow() == null && this.getDeny() == null, "One of 'allow' or 'deny' must be set.");
        this.parsePermissions(this.fAllowPermissions, this.getAllow());
        this.parsePermissions(this.fDenyPermissions, this.getDeny());
    }

    void parsePermissions(List fillIn, String permissions) {
        if (StringUtils.isEmpty((String)permissions)) {
            return;
        }
        String[] tabPermissions = permissions.split("\\W+");
        for (int i = 0; i < tabPermissions.length; ++i) {
            String name = tabPermissions[i];
            PDFEncryptionPermission pdfPermission = PDFEncryptionPermission.get(name);
            if (pdfPermission == null) {
                throw new StepExecutionException("Unknown PDF permission: \"" + name + "\"", this);
            }
            fillIn.add(pdfPermission);
        }
    }

    protected void verifyPdf(PDFPage pdfPage) {
        this.checkPermissions(pdfPage, this.fAllowPermissions, true);
        this.checkPermissions(pdfPage, this.fDenyPermissions, false);
    }

    private void checkPermissions(PDFPage pdfPage, List permissions, boolean expectedValue) {
        Iterator iter = permissions.iterator();
        while (iter.hasNext()) {
            PDFEncryptionPermission permission = (PDFEncryptionPermission)((Object)iter.next());
            boolean actualVallue = pdfPage.hasPermission(permission);
            if (actualVallue == expectedValue) continue;
            StringBuffer sb = new StringBuffer("Incorrect encryption permission found: ");
            sb.append(permission.getName());
            sb.append(" is ");
            if (expectedValue) {
                sb.append("not ");
            }
            sb.append("set");
            throw new StepFailedException(sb.toString(), this);
        }
    }
}

