/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.form;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.form.AbstractSetNamedFieldStep;
import com.canoo.webtest.util.FormUtil;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import java.util.List;
import org.apache.log4j.Logger;

public class SetInputField
extends AbstractSetNamedFieldStep {
    private static final Logger LOG = Logger.getLogger((Class)SetInputField.class);

    protected HtmlForm findForm() {
        return FormUtil.findFormForTextField(this.getContext(), this.getFormName(), this.getName(), this);
    }

    protected List findFields(HtmlForm form) {
        List fields = super.findFields(form);
        List textAreaFields = form.getTextAreasByName(this.getName());
        LOG.debug((Object)("Found " + textAreaFields.size() + " textarea field(s)"));
        fields.addAll(textAreaFields);
        return fields;
    }

    protected boolean keepField(HtmlElement elt) {
        return elt instanceof HtmlTextInput || elt instanceof HtmlPasswordInput || elt instanceof HtmlTextArea;
    }

    protected void setField(HtmlElement elt) {
        if (elt instanceof HtmlTextArea) {
            ((HtmlTextArea)elt).setText(this.getValue());
            LOG.debug((Object)("Set text for textarea " + elt + " to value " + this.getValue()));
        } else if (elt instanceof HtmlInput) {
            ((HtmlInput)elt).setValueAttribute(this.getValue());
            LOG.debug((Object)("Set text for input " + elt + " to value " + this.getValue()));
        } else {
            throw new StepFailedException("Found " + elt.getTagName() + " when looking for input", this);
        }
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.paramCheck(this.isValueNull(), "Attribute \"value\" must be set or inner text must be supplied!");
    }
}

