/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.store;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.store.BaseStoreStep;
import com.canoo.webtest.util.ConversionUtil;
import com.canoo.webtest.util.Evaluator;
import com.canoo.webtest.util.Expression;
import org.apache.commons.lang.StringUtils;

public class StorePropertyStep
extends BaseStoreStep
implements Evaluator {
    private String fPropertyValue;
    private String fEval;
    private String fName;

    public void doExecute() {
        String value = this.isEval() ? this.doEvaluate(this.getValue()) : this.getValue();
        this.storeProperty(value, this.getName());
    }

    String doEvaluate(String propertyValue) {
        double d = Expression.evaluateExpression(propertyValue, this);
        if (d == (double)((int)d)) {
            return Integer.toString((int)d);
        }
        return Double.toString(d);
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getValue() {
        return this.fPropertyValue;
    }

    public void setValue(String value) {
        this.fPropertyValue = value;
    }

    public boolean isEval() {
        return ConversionUtil.convertToBoolean(this.getEval(), false);
    }

    public String getEval() {
        return this.fEval;
    }

    public void setEval(String eval) {
        this.fEval = eval;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(StringUtils.defaultString((String)this.getProperty(), (String)this.fName), "name");
        this.nullParamCheck(this.getValue(), "value");
    }

    public double evaluate(String s) {
        String result = this.getProject().replaceProperties(s);
        try {
            return Double.parseDouble(result);
        }
        catch (NumberFormatException e) {
            throw new StepFailedException("Attempted to evaluate non-numeric property '" + s + "': " + e.getMessage(), this);
        }
    }

    public void addText(String text) {
        this.fPropertyValue = text;
    }
}

