/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.verify;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.verify.AbstractVerifyTextStep;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.Iterator;
import java.util.List;

public class VerifyElement
extends AbstractVerifyTextStep {
    private String fType;

    public String getType() {
        return this.fType;
    }

    public void setType(String newType) {
        this.fType = newType;
    }

    public void doExecute() {
        int numberOfHits = this.getNumberOfHits();
        if (numberOfHits > 1) {
            throw new StepFailedException("More than 1 element with type \"" + this.fType + "\" and name \"" + this.getText() + "\" found!", this);
        }
        if (numberOfHits == 0) {
            throw new StepFailedException("No element of type \"" + this.fType + "\" and name \"" + this.getText() + "\" found!", this);
        }
    }

    protected int getNumberOfHits(Context context) {
        return this.getNumberOfHits();
    }

    protected int getNumberOfHits() {
        Context context = this.getContext();
        int numberOfHits = this.findElementAttributeValue(context, this.getType(), "name", this.getText());
        if (numberOfHits == 0) {
            numberOfHits = this.findElementAttributeValue(context, this.getType(), "id", this.getText());
        }
        return numberOfHits;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getType(), "type");
    }

    private int findElementAttributeValue(Context context, String elementType, String attributeName, String value) {
        List li = VerifyElement.getAllElementsOfType(context, elementType.toLowerCase());
        return this.getNumberOfOccurances(li, value, attributeName);
    }

    protected static List getAllElementsOfType(Context context, String type) {
        return ((HtmlPage)context.getCurrentResponse()).getDocumentHtmlElement().getHtmlElementsByTagName(type);
    }

    protected int getNumberOfOccurances(List li, String expectedString, String attributeName) {
        int numberOfHits = 0;
        Iterator iter = li.iterator();
        while (iter.hasNext()) {
            HtmlElement elt = (HtmlElement)iter.next();
            if (!this.verifyStrings(expectedString, elt.getAttributeValue(attributeName))) continue;
            ++numberOfHits;
        }
        return numberOfHits;
    }
}

