import grails.converters.JSON
import grails.converters.XML
import java.text.SimpleDateFormat
import org.apache.commons.logging.Log

class NutzerController {

    static scaffold = Nutzer

    def show = {
        def result = Nutzer.get(params.id ?: 0)
        def view = [view: 'show', model: [nutzer: result]]
        if (!result) {
            result = Nutzer.list()
            view = [view: 'list', model: [nutzerList: result]]
        }
        withFormat {
            html { render(view) }
            xml  { render result as XML  }
            json { render result as JSON }
        }
    }

    def updateRest = {
        exceptionSafe {
            def nutzer = Nutzer.get(params.id)
            if (params.nutzer.birth){
                params.nutzer.birth = new SimpleDateFormat().parse(params.nutzer.birth)
            }
            nutzer.properties = params.nutzer
            saveOrError nutzer
        }
    }

    def deleteRest = {
        exceptionSafe {
            def nutzer = Nutzer.get(params.id)
            nutzer.delete(flush:true)
            render nutzer as XML
        } 
    }
    
    def saveRest = {
        exceptionSafe {
            params.nutzer.birth = new SimpleDateFormat().parse(params.nutzer.birth)
            saveOrError new Nutzer(params.nutzer)
        }
    }

    private void exceptionSafe(Closure yield) {
        try {
            yield()
        } catch (e) {
            render(contentType: "text/xml") {
                errors {
                    error(message: e.toString())
    }   }   }   }

    private void saveOrError(nutzer) {
        if (nutzer.save(flush:true)) {
            render nutzer as XML
        } else {
            def errorMessages = nutzer.errors.allErrors.collect {
                g.message(error: it)
            }
            render(contentType: "text/xml") {
                errors {
                    for (msg in errorMessages) {
                        error(message: msg) // example in docs is wrong here
    }   }   }   }   }
}