class NutzerTest extends grails.util.WebTest {

    // Unlike unit tests, functional tests are often sequence dependent.
    // Specify that sequence here.
    void suite() {
        testNutzerListNewDelete()
        // add tests for more operations here
    }

    def testNutzerListNewDelete() {
        webtest('Nutzer basic operations: view list, create new entry, view, edit, delete, view') {
            
            invoke      'nutzer'
            verifyText  'Home'

            verifyListSize 0

            group (description: "Insert new Nutzer") {
                clickLink   'New Nutzer'
                verifyText  'Create Nutzer'
                
                setInputField   name: "firstname",   "Dierk"
                setInputField   name: "lastname",    "Koenig"
                setInputField   name: "mail",         "dierk.koenig@canoo.com"
                setSelectField  name: "birth_day",    "19"
                setSelectField  name: "birth_year",   "1968"
                setSelectField  name: "birth_hour",   "00"
                setSelectField  name: "birth_minute", "00"

                clickButton 'Create'
                verifyText  'Show Nutzer', description:'Detail page'
                clickLink   'List',        description:'Back to list view'
            }
            verifyListSize 1

            group(description:'edit the one element') {
                showFirstElementDetails()
                clickButton 'Edit'
                verifyText  'Edit Nutzer'
                clickButton 'Update'
                verifyText  'Show Nutzer'
                clickLink   'List', description:'Back to list view'
            }
            verifyListSize 1

            group(description:'delete the only element') {
                showFirstElementDetails()
                clickButton 'Delete'
            }
            verifyListSize 0
        }
    }

    String ROW_COUNT_XPATH = "count(//div[@class='list']//tbody/tr)"

    def verifyListSize(int size) {
        ant.group(description:"verify Nutzer list view with $size row(s)") {
            verifyText  'Nutzer List'
            verifyXPath xpath:      ROW_COUNT_XPATH,
                        text:       size,
                        description:"$size row(s) of data expected"
        }
    }

    def showFirstElementDetails() {
        ant.clickLink   '1', description:'go to detail view'
    }
}