﻿using System;
using System.Windows.Controls;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Media.Imaging;

namespace FotoAlbum
{
    public partial class Page : UserControl
    {
        public Thumbnail _sender;

        public Page()
        {
            InitializeComponent();
            Storyboard FadeOutAnim = (Storyboard)this.FindName("FadeOutAnimation");
            FadeOutAnim.Completed += new EventHandler(FadeOutAnim_Completed);
            InitThumbnails();
        }

        private void CreateThumbnail(String img)
        {
            Thumbnail t = new Thumbnail(img);
            t.ImageSelected += new EventHandler(Thumbnail_ImageSelected);
            ThumbnailContainer.Children.Add(t);
        }

        private void InitThumbnails()
        {
            CreateThumbnail("http://farm2.static.flickr.com/1328/1422859939_b78ecb1196_o.jpg");
            CreateThumbnail("http://farm2.static.flickr.com/1180/1422928923_3c950be658_o.jpg");
            CreateThumbnail("http://farm2.static.flickr.com/1102/1423036119_ee2237203b_o.jpg");
            CreateThumbnail("http://farm2.static.flickr.com/1333/1423021817_da7f60150a_o.jpg");
            CreateThumbnail("http://farm2.static.flickr.com/1122/1423919860_7ff91dc410_o.jpg");
            CreateThumbnail("http://farm2.static.flickr.com/1244/1422904765_2fd2cd61e2_o.jpg");
            CreateThumbnail("http://farm2.static.flickr.com/1177/1423035773_44c7333b2d_o.jpg");
            CreateThumbnail("http://farm2.static.flickr.com/1431/1423105231_6059c2733f_o.jpg");
            CreateThumbnail("http://farm2.static.flickr.com/1122/1423919860_7ff91dc410_o.jpg");
        }

        private void Thumbnail_ImageSelected(object sender, EventArgs e)
        {
            Storyboard FadeOutAnim = (Storyboard)this.FindName("FadeOutAnimation");
            _sender = (Thumbnail)sender;
            FadeOutAnim.Begin();
        }

        private void FadeOutAnim_Completed(object sender, EventArgs e)
        {
            Storyboard FadeInAnim = (Storyboard)this.FindName("FadeInAnimation");
            Uri uri = new Uri(_sender.imageSource, UriKind.RelativeOrAbsolute);
            BitmapImage img = new System.Windows.Media.Imaging.BitmapImage(uri);
            DetailView.SetValue(Image.SourceProperty, img);
            FadeInAnim.Begin();
        }
    }
}
