﻿var myMap = null;
var myLayer = null;
var myStateMoving = false;
var myLayerHst = null;
var myCurrentHst = null;
var myLayerKunde = null;
var myLayerAuswahl = null;

function GetMap(){
    myMap = new VEMap('divMap');
    myMap.LoadMap();
    myMap.SetCenterAndZoom(new VELatLong(49.0213 ,12.0981), 13);

    myLayerHst = new VEShapeLayer();
    myMap.AddShapeLayer(myLayerHst);
    
    myLayerKunde = new VEShapeLayer();
    myMap.AddShapeLayer(myLayerKunde);
    
    myLayerAuswahl = new VEShapeLayer();
    myMap.AddShapeLayer(myLayerAuswahl);
}   

function ShowInfo(){
    alert("Center: " + myMap.GetCenter() + " Zoom:" + myMap.GetZoomLevel());
}

function ShowAll(){
    var url="./ShowAllHandler.ashx"
    
    myLayerKunde.DeleteAllShapes();
    myLayerHst.DeleteAllShapes();
    myLayerAuswahl.DeleteAllShapes();
    
    DoXMLHttp(url);
}

function CreateCustomer(){
    myMap.AttachEvent("onclick", PixelClick);
    
    myMap.vemapcontrol.EnableGeoCommunity(true);
    document.getElementById("divMap").style.cursor='crosshair';
}

function PixelClick(e){
    var pixel = new VEPixel(e.mapX, e.mapY);
    var ll =  myMap.PixelToLatLong(pixel);
    
    myMap.vemapcontrol.EnableGeoCommunity(false);
    document.getElementById("divMap").style.cursor='';
    
    var url="./InsertKundeHandler.ashx?"
        url += "&Lat=" + ll.Latitude;
        url += "&Lon=" + ll.Longitude;;
        DoXMLHttp(url);
}

function BeginCreateHst(){
    myMap.AttachEvent("onclick", MouseClick);
    
    myMap.vemapcontrol.EnableGeoCommunity(true);
    document.getElementById("divMap").style.cursor='crosshair';
    
    myStateMoving = true;
    document.getElementById("CreateHstButton").disabled=true;  
    document.getElementById("txtNr").disabled=false;
    document.getElementById("txtName").disabled=false;
    document.getElementById("txtOrt").disabled=false;
    document.getElementById("OkCreateHstButton").disabled=false;
    document.getElementById("CancleCreateHstButton").disabled=false;
}

function MouseClick(e){
    if (myStateMoving){
        var x = e.mapX;
        var y = e.mapY;
        pixel = new VEPixel(x, y);
        var ll = myMap.PixelToLatLong(pixel);
        if(myCurrentHst==null){
            myCurrentHst = new VEShape(VEShapeType.Pushpin, ll);
            myCurrentHst.SetCustomIcon('Hst.png');
            myLayerHst.AddShape(myCurrentHst);
        } else {
            myCurrentHst.SetPoints(ll);
        }
        document.getElementById("txtLat").value = ll.Latitude;
        document.getElementById("txtLon").value = ll.Longitude;
    }
}

function EndCreateHst(isOk){
    myMap.vemapcontrol.EnableGeoCommunity(false);
    document.getElementById("divMap").style.cursor='';
    
    if(isOk){
        var url="./InsertHstHandler.ashx?"
        url += "&Nr=" + document.getElementById("txtNr").value;
        url += "&Name=" + document.getElementById("txtName").value;
        url += "&Ort=" + document.getElementById("txtOrt").value;
        url += "&Lat=" + document.getElementById("txtLat").value;
        url += "&Lon=" + document.getElementById("txtLon").value;
        DoXMLHttp(url);
    }
}

function ShowGeoRSS(){
    var url="./ShowGeoRSSHandler.ashx"
    //url="./georsstest.xml"
    myLayer = new VEShapeLayer();
    myMap.AddShapeLayer(myLayer);
    
    var myLayerSpec = new VEShapeSourceSpecification(VEDataType.GeoRSS,url,myLayer);
    myMap.ImportShapeLayerData(myLayerSpec,null,true); //Specification, Callback, Best View
    
}

function ShowAsShapes(){
    var url="./ShowAsShapesHandler.ashx"
    
    myLayer = new VEShapeLayer();
    myMap.AddShapeLayer(myLayer);
    
    DoXMLHttp(url);
}

function TestConnection(){
    var ll = myMap.GetCenter();
    var lat = ll.Latitude;
    var lon = ll.Longitude;

    var url="./Test.ashx?"
    url += "&Lat=" + lat;
    url += "&Lon=" + lon;
    myLayer = new VEShapeLayer();
    myMap.AddShapeLayer(myLayer);
        
    DoXMLHttp(url);
}

function DoXMLHttp(url){
    var xmlHttp=GetXmlHttp();
    if (xmlHttp) {
        xmlHttp.Open("GET",url,true); //true=asynchron
        
        xmlHttp.onreadystatechange = function(){ //callback setzen
            if (xmlHttp.readystate==4){ //alles okay
                var result = xmlHttp.responseText;
                eval(result);
                //alert(result);
            }
        }
        xmlHttp.send(null);
    }
}

function GetXmlHttp(){
    var xmlHttp=null;
    
    // Internet Explorer 6 und älter
    try {
        xmlHttp  = new ActiveXObject("Msxml2.XMLHTTP");
    } catch(e) {
        try {
            xmlHttp  = new ActiveXObject("Microsoft.XMLHTTP");
        } catch(e) {
            xmlHttp  = null;
        }
    }
    // Mozilla, Opera, Safari sowie Internet Explorer 7
    if (!xmlHttp && XMLHttpRequest != 'undefined') {
        xmlHttp = new XMLHttpRequest();
    }
    return xmlHttp;
}