﻿Imports System.Web
Imports System.Web.Services
Imports System.Data.SqlClient

Public Class ShowAllHandler
    Implements System.Web.IHttpHandler

    Sub ProcessRequest(ByVal context As HttpContext) Implements IHttpHandler.ProcessRequest
        CreateLayer(context, "select GeoStandort.Lat, GeoStandort.Long from AboKunde", "myLayerKunde", "KundeB.png")
        CreateLayer(context, "select GeoStandort.Lat, GeoStandort.Long from Haltestelle", "myLayerHst", "Hst.png")
        CreateLayer(context, "select AboKunde.GeoStandort.Lat, AboKunde.GeoStandort.Long from AboKunde, Haltestelle " & _
                             "where AboKunde.GeoStandort.STDistance(Haltestelle.GeoStandort) < 300", _
                    "myLayerAuswahl", "KundeR.png")

    End Sub

    Private Sub CreateLayer(ByVal context As HttpContext, ByVal selectStatement As String, ByVal layerName As String, ByVal iconName As String)
        Dim connectionString As String = "Data Source=(local);Initial Catalog=BusCompany;Integrated Security=True" '"Provider=SQLOLEDB;Data Source=(local);Integrated Security=SSPI;Initial Catalog=BusCompany"
        context.Response.Write("var shape = null;")

        Using connection As New SqlConnection(connectionString)
            connection.Open()

            Dim command = New SqlCommand(selectStatement, connection)
            Dim reader = command.ExecuteReader

            While reader.Read
                Dim pLat = CDbl(reader(0)).ToString(System.Globalization.CultureInfo.InvariantCulture)
                Dim pLon = CDbl(reader(1)).ToString(System.Globalization.CultureInfo.InvariantCulture)
                context.Response.Write("shape = new VEShape(VEShapeType.Pushpin, new VELatLong(" & pLat & "," & pLon & "));")
                context.Response.Write("shape.SetCustomIcon('" & iconName & "');")
                context.Response.Write(layerName & ".AddShape(shape);")
            End While
        End Using
    End Sub

    ReadOnly Property IsReusable() As Boolean Implements IHttpHandler.IsReusable
        Get
            Return False
        End Get
    End Property

End Class