package sample.ix.ui.views;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.ViewPart;

import sample.ix.Activator;
import sample.ix.image.IImageLoader;



/**
 * Implementation of IViewPart.
 * */
public class ContentView extends ViewPart {

	/**
	 * ID of this View
	 * */
	public static final String ID = "sample.ix.ui.contentView";

	private IImageLoader imageLoader;
	/**
	 * The ImageLabel used to hold the images.
	 * */
	private Label imageLabel;

	/**
	 * Custom Constructor.
	 * 
	 * Used to load the ImageLoader from the Activator-Instance.
	 * */
	public ContentView() {

		imageLoader = Activator.getDefault().getImageLoader();
	}

	/**
	 * Method in which the Contents of this View are generated.
	 * 
	 * @param the parent Composite to hold the content.
	 * */
	public void createPartControl(Composite parent) {

		parent.setLayout(new FillLayout(SWT.VERTICAL));

		Composite container = new Composite(parent, SWT.BORDER);
		container.setLayout(new GridLayout());

		imageLabel = new Label(container, SWT.CENTER);
			
		GridData labelData = new GridData(SWT.FILL, SWT.FILL, true, true);
		imageLabel.setLayoutData(labelData);

		Group buttonGroup = new Group(container, SWT.NONE);
		GridData buttonGroupData = new GridData(SWT.FILL, SWT.NONE, true, false);
		buttonGroup.setLayoutData(buttonGroupData);
		buttonGroup.setLayout(new GridLayout(3,false));

		GridData buttonData = new GridData();
		buttonData.widthHint = 120;
		
		Button prev = new Button(buttonGroup, SWT.PUSH);
		prev.setLayoutData(buttonData);
		prev.setText(" < ");
		prev.addSelectionListener(new SelectionAdapter() {

			public void widgetSelected(SelectionEvent ev) {
				Image im = imageLoader.getPreviousImage();
				imageLabel.setImage(im);
			}

		});
		Composite filler = new Composite(buttonGroup, SWT.PUSH);
		GridData fillerData = new GridData(SWT.FILL, SWT.NONE, true,false);
		filler.setLayoutData(fillerData);
		Button next = new Button(buttonGroup, SWT.PUSH);
		next.setLayoutData(buttonData);
		next.setText(" > ");
		next.addSelectionListener(new SelectionAdapter() {

			public void widgetSelected(SelectionEvent ev) {
				Image im = imageLoader.getNextImage();
				imageLabel.setImage(im);
			}

		});
	}
	/**
	 * Method which gets called when view receives the Focus.
	 * 
	 * Does nothing.
	 * */
	public void setFocus() {
		//Nothing to do.
	}

}
