/*
 * InstallationsartPanel.java
 * 
 * geschrieben 2008 von Thomas Knneth
 * 
 * Dieser Quelltext ist Bestandteil des Artikels
 * Assistenten in Java - die Wizard API
 */
package com.thomaskuenneth.articles.ix.wizard;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;

import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPanel;
import org.netbeans.spi.wizard.WizardPanelNavResult;

@SuppressWarnings("serial")
public class InstallationsartPanel extends BasePanel implements WizardPanel,
		ActionListener {

	public static final String STEP_ID = "InstallationsartPanel_id";
	public static final String DESCRIPTION = "Installationsart";

	public static final String RB_ALLES = "rbAlles";
	public static final String RB_AUSWAHL = "rbAuswahl";

	private Map settings;
	private JRadioButton rbAlles, rbAuswahl;

	public InstallationsartPanel(Map settings) {
		this.settings = settings;
		add(Utilities.createReadOnlyTextArea("Bitte whlen Sie aus, "
				+ "welche Pakete Sie installieren mchten.", false, true),
				BorderLayout.NORTH);
		Box p = Box.createVerticalBox();
		rbAlles = new JRadioButton("alle Pakete");
		rbAlles.addActionListener(this);
		rbAlles.setName(RB_ALLES);
		rbAuswahl = new JRadioButton("Ich mchte die Pakete selbst auswhlen.");
		rbAuswahl.addActionListener(this);
		rbAuswahl.setName(RB_AUSWAHL);
		ButtonGroup bg = new ButtonGroup();
		bg.add(rbAlles);
		bg.add(rbAuswahl);
		p.add(rbAlles);
		p.add(rbAuswahl);
		p.createGlue();
		bg.setSelected(rbAuswahl.getModel(), true);
		add(p, BorderLayout.CENTER);
	}

	private void updateMap(Map settings) {
		settings.put(rbAlles.getName(), new Boolean(rbAlles.isSelected()));
		settings.put(rbAuswahl.getName(), new Boolean(rbAuswahl.isSelected()));
	}

	public WizardPanelNavResult allowBack(String stepName, Map settings,
			Wizard wizard) {
		return WizardPanelNavResult.PROCEED;
	}

	public WizardPanelNavResult allowFinish(String stepName, Map settings,
			Wizard wizard) {
		return WizardPanelNavResult.REMAIN_ON_PAGE;
	}

	public WizardPanelNavResult allowNext(String stepName, Map settings,
			Wizard wizard) {
		updateMap(settings);
		return WizardPanelNavResult.PROCEED;
	}

	public void actionPerformed(ActionEvent e) {
		updateMap(settings);
	}
}
