/*
 * InstallerDemo.java
 * 
 * geschrieben 2008 von Thomas Knneth
 * 
 * Dieser Quelltext ist Bestandteil des Artikels
 * Assistenten in Java - die Wizard API
 */
package com.thomaskuenneth.articles.ix.wizard;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.spi.wizard.Wizard;

public class InstallerDemo {

	@SuppressWarnings("serial")
	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Throwable thr) {
			Logger.getLogger(InstallerDemo.class.getName()).log(Level.WARNING,
					"Setzen des Look and Feels fehlgeschlagen", thr);
		}
		// Gre des Wizards festlegen
		int breite = 600;
		int hoehe = 400;
		// Wizard erzeugen
		Wizard wizard = new InstallerDemoBranchController().createWizard();
		// und anzeigen
		Action actionHilfe = new AbstractAction("Hilfe") {

			public void actionPerformed(ActionEvent e) {
				JOptionPane.showMessageDialog(null, "Hilfe!");
			}
		};
		Dimension bildschirm = Toolkit.getDefaultToolkit().getScreenSize();
		Object ergebnis = WizardDisplayer.showWizard(wizard, new Rectangle(
				(bildschirm.width - breite) / 2,
				(bildschirm.height - hoehe) / 2, breite, hoehe), actionHilfe,
				null);
		// der Rckgabewert der finish()-Methode
		System.out.println(ergebnis);
	}
}
