/*
 * InstallerDemoDeferredWizardResult.java
 * 
 * geschrieben 2008 von Thomas Knneth
 * 
 * Dieser Quelltext ist Bestandteil des Artikels
 * Assistenten in Java - die Wizard API
 */
package com.thomaskuenneth.articles.ix.wizard;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;

public class InstallerDemoDeferredWizardResult extends DeferredWizardResult {

	@Override
	public void start(Map settings, final ResultProgressHandle progress) {
		try {
			progress.setProgress("Dateien kopieren", 0, 3);
			warten();
			progress.setProgress("Leistung optimieren", 1, 3);
			warten();
			progress.setProgress("Installation abschlieen", 2, 3);
			warten();
			progress.finished(getSummary(settings));
		} catch (Throwable thr) {
			progress.failed(thr.getMessage(), false);
		}
	}

	private void warten() throws InterruptedException {
		Thread.sleep(3000);
	}

	private Summary getSummary(Map settings) {
		StringBuilder sb = new StringBuilder();
		sb.append("Die Installation ist abgeschlossen.\n");
		if (settings != null) {
			Set set = settings.keySet();
			Iterator iter = set.iterator();
			while (iter.hasNext()) {
				String key = (String) iter.next();
				sb.append(key + " = " + settings.get(key) + "\n");
			}
		}
		return Summary.create(sb.toString(), settings);
	}
}
