/*
 * LizenzbedingungenPanel.java
 * 
 * geschrieben 2008 von Thomas Knneth
 * 
 * Dieser Quelltext ist Bestandteil des Artikels
 * Assistenten in Java - die Wizard API
 */
package com.thomaskuenneth.articles.ix.wizard;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBox;

import org.netbeans.spi.wizard.WizardController;

@SuppressWarnings("serial")
public class LizenzbedingungenPanel extends BasePanel {

	public static final String STEP_ID = "Lizenzbedingungen_id";
	public static final String DESCRIPTION = "Lizenzbedingungen";

	private WizardController controller;
	private JCheckBox cb;

	public LizenzbedingungenPanel(WizardController controller) {
		this.controller = controller;
		add(Utilities.createReadOnlyTextArea("Bitte lesen und akzeptieren Sie "
				+ "die folgenden Lizenzbedingungen:", false, true),
				BorderLayout.NORTH);
		add(Utilities.createReadOnlyTextArea(
				"Dies sind die Lizenzbedingungen fr "
						+ "das Produkt VaporOffice XT. ... .... ... .....",
				true, false), BorderLayout.CENTER);
		cb = new JCheckBox("Ich stimme den Lizenzbedingungen zu.", false);
		add(cb, BorderLayout.SOUTH);
		cb.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				setProblem();
			}
		});
		setProblem();
	}

	private void setProblem() {
		controller.setProblem(cb.isSelected() ? null
				: "Bitte stimmen Sie den Bedingungen zu oder "
						+ "klicken auf Abbrechen.");
	}
}
