/*
 * StartseitePanel.java
 * 
 * geschrieben 2008 von Thomas Knneth
 * 
 * Dieser Quelltext ist Bestandteil des Artikels
 * Assistenten in Java - die Wizard API
 */
package com.thomaskuenneth.articles.ix.wizard;

import java.awt.BorderLayout;
import java.awt.Font;
import java.util.Map;

import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPanel;
import org.netbeans.spi.wizard.WizardPanelNavResult;

@SuppressWarnings("serial")
public class StartseitePanel extends BasePanel implements WizardPanel {

	public static final String STEP_ID = "Startseite_id";
	public static final String DESCRIPTION = "Startseite";

	public StartseitePanel() {
		JLabel headline = new JLabel("Herzlich Willkommen!");
		headline.setFont(headline.getFont().deriveFont(Font.BOLD).deriveFont(
				16f));
		headline.setBorder(new EmptyBorder(0, 0, 10, 0));
		add(headline, BorderLayout.NORTH);
		add(Utilities.createReadOnlyTextArea("Dieser Assistent fhrt Sie in "
				+ "wenigen Schritten durch die Installation von "
				+ "VaporOffice XT.", false, true), BorderLayout.CENTER);
	}

	public WizardPanelNavResult allowBack(String stepName, Map settings,
			Wizard wizard) {
		return WizardPanelNavResult.REMAIN_ON_PAGE;
	}

	public WizardPanelNavResult allowFinish(String stepName, Map settings,
			Wizard wizard) {
		return WizardPanelNavResult.REMAIN_ON_PAGE;
	}

	public WizardPanelNavResult allowNext(String stepName, Map settings,
			Wizard wizard) {
		return WizardPanelNavResult.PROCEED;
	}
}
