/*
 * StartseitePanelProvider.java
 * 
 * geschrieben 2008 von Thomas Knneth
 * 
 * Dieser Quelltext ist Bestandteil des Artikels
 * Assistenten in Java - die Wizard API
 */
package com.thomaskuenneth.articles.ix.wizard;

import java.util.Map;

import javax.swing.JComponent;

import org.netbeans.spi.wizard.WizardController;
import org.netbeans.spi.wizard.WizardPanelProvider;

@SuppressWarnings("serial")
public class StartseitePanelProvider extends WizardPanelProvider {

	public StartseitePanelProvider() {
		super("Installer-Demo", new String[] { StartseitePanel.STEP_ID,
				LizenzbedingungenPanel.STEP_ID, ZielverzeichnisPanel.STEP_ID,
				InstallationsartPanel.STEP_ID }, new String[] {
				StartseitePanel.DESCRIPTION,
				LizenzbedingungenPanel.DESCRIPTION,
				ZielverzeichnisPanel.DESCRIPTION,
				InstallationsartPanel.DESCRIPTION });
	}

	@Override
	protected JComponent createPanel(WizardController controller, String id,
			Map settings) {
		if (StartseitePanel.STEP_ID.equals(id)) {
			return new StartseitePanel();
		} else if (LizenzbedingungenPanel.STEP_ID.equals(id)) {
			return new LizenzbedingungenPanel(controller);
		} else if (ZielverzeichnisPanel.STEP_ID.equals(id)) {
			return new ZielverzeichnisPanel(controller);
		} else if (InstallationsartPanel.STEP_ID.equals(id)) {
			return new InstallationsartPanel(settings);
		}
		return null;
	}
}
