package de.kompf.xmpp.app;

import java.io.IOException;

import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;

import de.kompf.xmpp.data.LocationDataExtension;

/**
 * Demonstrate the receiving of extended XMPP data.
 * 
 * @author kompf
 * 
 */
public class SampleLocationDataReceiver extends XmppAppBase {

  /**
   * The user to connect to Jabber. This is the first part of the JID.
   */
  private static final String USER = "otheruser";

  /**
   * The Jabber service name. This is the second part of the JID.
   */
  private static final String SERVICE_NAME = "googlemail.com";

  /**
   * The Jabber host name.
   */
  private static final String JABBER_HOST = "talk.google.com";

  /**
   * The Jabber port.
   */
  private static final int JABBER_PORT = 5222;

  /**
   * MAIN.
   * 
   * @param args
   *          ignored
   * @throws XMPPException
   * @throws IOException
   */
  public static void main(String[] args) throws XMPPException {
    // XMPPConnection.DEBUG_ENABLED = true;

    SampleLocationDataReceiver receiver = new SampleLocationDataReceiver();

    receiver.connectXmppService(JABBER_HOST, JABBER_PORT, SERVICE_NAME, USER,
        password(USER + "@" + SERVICE_NAME));
    System.out.println("Connected");

    receiver.listen();

    while (true) {
      System.out.println("Listening...");
      try {
        Thread.sleep(60000);
      } catch (InterruptedException e) {
        System.out.println("Interrupt");
        System.exit(1);
      }
    }

  }

  /**
   * Listen for incoming LocationDataExtension packets.
   */
  private void listen() {
    // install LocationDataExtension
    LocationDataExtension.install(ProviderManager.getInstance());

    // register asynchronous PacketListener for LocationDataExtension
    mXmppConnection.addPacketListener(new PacketListener() {
      public void processPacket(Packet packet) {
        LocationDataExtension locationDataExtension = (LocationDataExtension) packet
            .getExtension(LocationDataExtension.NAMESPACE);
        // process location data
        processLocation(StringUtils.parseBareAddress(packet.getFrom()),
            locationDataExtension);
      }
    }, new PacketExtensionFilter(LocationDataExtension.NAMESPACE));
  }

  /**
   * Process the received location.
   * 
   * @param locationData
   */
  private void processLocation(String from, LocationDataExtension locationData) {
    if (acceptSender(from)) {
      System.out.println();
      System.out.print("Received location from: " + from);

      System.out.printf(" time: %1$tD %1$tT lat: %2$.5f lon: %3$.5f",
          locationData.getTime(), locationData.getLatitude(), locationData
              .getLongitude());
      if (locationData.hasAltitude()) {
        System.out.printf(" alt: %.0f", locationData.getAltitude());
      }
      System.out.println();
    }
  }

  /**
   * Check the from address of a packet.
   * 
   * @param from
   *          The sender's address.
   * @return if the sender is accepted.
   */
  private boolean acceptSender(String from) {
    boolean accept = true;
    // check from against database ...
    // ...
    return accept;
  }

}
