package de.kompf.xmpp.app;

import java.io.IOException;

import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

import de.kompf.xmpp.data.LocationDataExtension;
import de.kompf.xmpp.mock.GPS;
import de.kompf.xmpp.mock.Location;

/**
 * Demonstrate the sending of extended XMPP data.
 * 
 * @author kompf
 * 
 */
public class SampleLocationDataSender extends XmppAppBase {

  /**
   * The user to connect to Jabber. This is the first part of the JID.
   */
  private static final String USER = "myuser";

  /**
   * The Jabber service name. This is the second part of the JID.
   */
  private static final String SERVICE_NAME = "gmx.de";

  /**
   * The Jabber host name.
   */
  private static final String JABBER_HOST = "jabber.gmx.net";

  /**
   * The Jabber port.
   */
  private static final int JABBER_PORT = 5222;

  /**
   * The JID of the receiver.
   */
  private static final String mReceiver = "otheruser@googlemail.com";

  /**
   * Time between two location messages in milliseconds.
   */
  private static final long updateInterval = 20000;

  /**
   * MAIN.
   * 
   * @param args
   *          ignored
   * @throws XMPPException
   * @throws IOException
   */
  public static void main(String[] args) throws XMPPException {
    // XMPPConnection.DEBUG_ENABLED = true;

    SampleLocationDataSender sender = new SampleLocationDataSender();

    sender.connectXmppService(JABBER_HOST, JABBER_PORT, SERVICE_NAME, USER,
        password(USER + "@" + SERVICE_NAME));
    System.out.println("Connected");

    while (true) {
      Location location = GPS.readNext();
      sender.sendLocationToPeer(mReceiver, location);

      try {
        Thread.sleep(updateInterval);
      } catch (InterruptedException e) {
      }
    }
  }

  /**
   * Send location via XMPP.
   * 
   * @param recipient
   * @param location
   */
  private void sendLocationToPeer(String recipient, Location location) {
    if (mXmppConnection != null) {
      // create message
      LocationDataExtension sampleData = new LocationDataExtension();
      sampleData.setLatitude(location.getLatitude());
      sampleData.setLongitude(location.getLongitude());
      sampleData.setTime(location.getTime());
      if (location.hasAltitude()) {
        sampleData.setAltitude(location.getAltitude());
      }

      Message mesg = new Message(recipient, Message.Type.chat);
      mesg.addExtension(sampleData);

      // send message
      mXmppConnection.sendPacket(mesg);

      System.out.println("sent message: " + mesg.toXML());
    }
  }

}
