package de.kompf.xmpp.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.ConnectionConfiguration.SecurityMode;
import org.jivesoftware.smack.packet.Presence;

/**
 * Common methods for Smack XMPP applications.
 * 
 * @author Kompf
 * 
 */
public abstract class XmppAppBase {

  protected XMPPConnection mXmppConnection;

  /**
   * Connect and login to the Jabber server.
   * 
   * @throws XMPPException
   */
  protected void connectXmppService(String host, int port, String serviceName,
      String user, String password) throws XMPPException {
    ConnectionConfiguration connectionConfig = new ConnectionConfiguration(
        host, port, serviceName);
    connectionConfig.setSecurityMode(SecurityMode.required);
    mXmppConnection = new XMPPConnection(connectionConfig);
    mXmppConnection.connect();
    mXmppConnection.login(user, password);

    // Set the status to available
    Presence presence = new Presence(Presence.Type.available);
    mXmppConnection.sendPacket(presence);
  }

  /**
   * Read the password for a given JID from xmppdemo.properties
   * 
   * @param jid
   *          The JID.
   * @return The password.
   */
  protected static String password(String jid) {
    String password = null;
    File passwordFile = new File("xmppdemo.properties");

    try {
      FileInputStream fin = new FileInputStream(passwordFile);
      Properties props = new Properties();
      props.load(fin);
      fin.close();

      password = props.getProperty(jid);
      if (password == null) {
        throw new RuntimeException("Please add line '" + jid
            + " : <password>' to file " + passwordFile.getAbsolutePath());
      }
    } catch (IOException e) {
      throw new RuntimeException("Can't read password from file "
          + passwordFile.getAbsolutePath() + ": " + e);
    }

    return password;
  }

}
