/**
 * 
 */
package de.kompf.xmpp.data;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.ProviderManager;

/**
 * Smack packet extension to transfer location data over XMPP.
 * @author kompf
 * 
 */
public class LocationDataExtension implements PacketExtension {

  /**
   * The namespace of this extension.
   */
	public static final String NAMESPACE = "urn:ix:xmppdemo";
	
	/**
	 * The top level element name of this extension.
	 */
	public static final String ELEMENT_NAME = "locationdata";

	private double mLatitude;
	private double mLongitude;
	private long mTime;
	private double mAltitude;
	private boolean mHasAltitude;
	
	 /**
   * Install this extension.
	 * @param manager The provider manager of smack.
   * 
   */
  public static void install(ProviderManager manager) {
    manager.addExtensionProvider(LocationDataExtension.ELEMENT_NAME,
        LocationDataExtension.NAMESPACE,
        LocationDataExtension.class);
  }

	
	/**
	 * @see org.jivesoftware.smack.packet.PacketExtension#getElementName()
	 */
	public String getElementName() {
		return ELEMENT_NAME;
	}

	/**
	 * @see org.jivesoftware.smack.packet.PacketExtension#getNamespace()
	 */
	public String getNamespace() {
		return NAMESPACE;
	}


	/**
	 * @see org.jivesoftware.smack.packet.PacketExtension#toXML()
	 */
	public String toXML() {
	  StringBuilder buf = new StringBuilder();
		buf.append("<").append(getElementName()).append(" xmlns=\"").append(
				getNamespace()).append("\">");
		buf.append("<latitude>").append(mLatitude).append("</latitude>").append(
				"<longitude>").append(mLongitude).append("</longitude>").append(
				"<time>").append(mTime).append("</time>");
		if (mHasAltitude) {
		  buf.append("<altitude>").append(mAltitude).append("</altitude>");
		}
		buf.append("</").append(getElementName()).append(">");
		return buf.toString();
	}

  /**
   * @return the latitude
   */
  public double getLatitude() {
    return mLatitude;
  }

  /**
   * @param latitude the latitude to set
   */
  public void setLatitude(double latitude) {
    mLatitude = latitude;
  }

  /**
   * @return the longitude
   */
  public double getLongitude() {
    return mLongitude;
  }

  /**
   * @param longitude the longitude to set
   */
  public void setLongitude(double longitude) {
    mLongitude = longitude;
  }

  /**
   * @return the time
   */
  public long getTime() {
    return mTime;
  }

  /**
   * @param time the time to set
   */
  public void setTime(long time) {
    mTime = time;
  }

  /**
   * @return the altitude
   */
  public double getAltitude() {
    return mAltitude;
  }

  /**
   * @param altitude the altitude to set
   */
  public void setAltitude(double altitude) {
    mHasAltitude = true;
    mAltitude = altitude;
  }

  /**
   * 
   * @return If this location has a valid altitude.
   */
  public boolean hasAltitude() {
    return mHasAltitude;
  }
}
