import java.sql.SQLException;
import java.sql.Connection;
import oracle.jdbc.OracleTypes;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.STRUCT;

public class VogelRef implements ORAData, ORADataFactory
{
  public static final String _SQL_BASETYPE = "OBJECT.VOGEL";
  public static final int _SQL_TYPECODE = OracleTypes.REF;

  REF _ref;

private static final VogelRef _VogelRefFactory = new VogelRef();

  public static ORADataFactory getORADataFactory()
  { return _VogelRefFactory; }
  /* constructor */
  public VogelRef()
  {
  }

  /* ORAData interface */
  public Datum toDatum(Connection c) throws SQLException
  {
    return _ref;
  }

  /* ORADataFactory interface */
  public ORAData create(Datum d, int sqlType) throws SQLException
  {
    if (d == null) return null; 
    VogelRef r = new VogelRef();
    r._ref = (REF) d;
    return r;
  }

  public static VogelRef cast(ORAData o) throws SQLException
  {
     if (o == null) return null;
     try { return (VogelRef) getORADataFactory().create(o.toDatum(null), OracleTypes.REF); }
     catch (Exception exn)
     { throw new SQLException("Unable to convert "+o.getClass().getName()+" to VogelRef: "+exn.toString()); }
  }

  public Vogel getValue() throws SQLException
  {
     return (Vogel) Vogel.getORADataFactory().create(
       _ref.getSTRUCT(), OracleTypes.REF);
  }

  public void setValue(Vogel c) throws SQLException
  {
    _ref.setValue((STRUCT) c.toDatum(_ref.getJavaSqlConnection()));
  }
}
