#include <occi.h>
#include <iostream>

#include "tiere.hpp"
#include "RegisterMappings.h"

using namespace oracle::occi;

int main()
{
    Environment *env = Environment::createEnvironment(Environment::OBJECT);
    
    // von Oracle generierte Klassen zur Verwendung registrieren
    RegisterMappings( env );

    {
	Connection *conn = env->createConnection(
	    "object", "object", "");

	// Referenzen auf alle Tiere selektieren
	Statement *stmt = conn->createStatement(
	    "SELECT ref(t) FROM tiere t");

	ResultSet *rs = stmt->executeQuery();

	std::cout << "Alle Tiere" << std::endl << std::endl;

	while( rs->next() ) {

	    Ref<tier> tr = rs->getRef( 1 );

	    // Referenz benutzen;  tr->getName() holt das Objekt aus der DB
	    std::cout << tr->getName() << " Typ: " << tr->getSQLTypeName() << std::endl;

	    if( dynamic_cast<elefant*>( tr.ptr() ) ) {
		// Elefant gefunden
		Ref<elefant> el( tr );
		std::cout << "Ruessellaenge: " << int( el->getRuessellange() ) << std::endl;
	    }
	}

	// Pfleger und seine Tiere selektieren
	stmt = conn->createStatement( "SELECT ref(p) FROM pfleger p");
	rs = stmt->executeQuery();

	std::cout << std::endl<< "Alle Pfleger mit Tieren" << std::endl << std::endl;

	while( rs->next() ) {
	    Ref<pfleger_t> pf = rs->getRef( 1 );
	    std::cout << pf->getName() << std::endl;

	    const std::vector<Ref<tier> >& tiere = pf->getPflegt();

	    for( std::vector<Ref<tier> >::const_iterator iter = tiere.begin(); iter != tiere.end(); ++iter ) {
		std::cout << "\t" << (*iter)->getName() << std::endl;
	    }
	}
    }
    Environment::terminateEnvironment(env);
}
