﻿Imports System.Data.Services.Client
Imports System.Collections.ObjectModel
Imports SilverlightCRUDDemo.NorthwndService
Imports System.Windows.Browser

Partial Public Class Page
    Inherits UserControl

    Private _context As NorthwndEntities
    Private WithEvents _customerCollection As ObservableCollection(Of Customer)
    Private WithEvents _customerDetailView As CustomerDetailView
    Private WithEvents _c As Customer

    Public Sub New()
        InitializeComponent()
        _context = New NorthwndEntities(New Uri("Northwnd.svc", UriKind.Relative))
        setDataContext()
    End Sub

    Private Sub ObjectPanel_SelectionChanged(ByVal sender As Object, ByVal e As System.Windows.Controls.SelectionChangedEventArgs) Handles ObjectPanel.SelectionChanged
        'Select Case CType(ObjectPanel.SelectedItem, ListBoxItem).Content
        '    Case "Customer"
        ReadAllCustomer()
        'End Select
    End Sub

    Private Sub MyDataGrid_AutoGeneratingColumn(ByVal sender As Object, ByVal e As System.Windows.Controls.DataGridAutoGeneratingColumnEventArgs) Handles MyDataGrid.AutoGeneratingColumn
        If e.PropertyName = "CustomerDemographics" _
         OrElse e.PropertyName = "Orders" Then
            e.Cancel = True
        End If

    End Sub

    Private Sub ReadAllCustomer()

        _context.BeginExecute(Of Customer)(New Uri("CustomerMenge", UriKind.Relative), _
                                                     AddressOf ReadCustomerCallback, _context)
        StatusText.Text = "Loading ..."
    End Sub

    Dim _response As QueryOperationResponse(Of Customer)

    Private Sub ReadCustomerCallback(ByVal asyncResult As IAsyncResult)
        _context = asyncResult.AsyncState
        _response = _context.EndExecute(Of Customer)(asyncResult) 'Rückgabe vom Typ: QueryOperationResponse
        Dispatcher.BeginInvoke(AddressOf setDataContext)
    End Sub

    Private Sub setDataContext()
        _customerCollection = New ObservableCollection(Of Customer)
        If _response IsNot Nothing Then
            For Each item In _response
                _customerCollection.Add(item)
            Next
        End If
        MyDataGrid.DataContext = _customerCollection
        StatusText.Text = ""
    End Sub

    Private _pageSize = 10
    Private _currentPage = -1

    Private Sub ReadCustomerWithQuery()
        Dim query = CType((From c In _context.CustomerMenge _
                           Order By c.CustomerID _
                           Skip (_currentPage * _pageSize) _
                           Take _pageSize _
                           Select c), DataServiceQuery(Of Customer))
        query.BeginExecute(AddressOf ReadCustomerWithQueryCallback, query)
        StatusText.Text = "Reading ..."
    End Sub

    Private Sub ReadCustomerWithQueryCallback(ByVal result As IAsyncResult)
        Try
            Dim queryResult = CType(result.AsyncState, DataServiceQuery(Of Customer))
            _response = queryResult.EndExecute(result)

            Dispatcher.BeginInvoke(AddressOf setDataContext)

        Catch e As DataServiceRequestException
            StatusText.Text = "Error:" & e.Message.ToString
        End Try
    End Sub

    Private Sub ShowCustomerDetailView()
        _customerDetailView = New CustomerDetailView
        _customerDetailView.Visibility = Windows.Visibility.Visible
        LayoutRoot.Children.Add(_customerDetailView)
        Grid.SetRowSpan(_customerDetailView, 2)
        Grid.SetColumnSpan(_customerDetailView, 2)
    End Sub

    Private Sub ReadButton_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs)
        ReadAllCustomer()
    End Sub

    Private Sub PreviousPageButton_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs)
        _currentPage = Math.Max(0, _currentPage - 1)
        ReadCustomerWithQuery()
    End Sub

    Private Sub NextPageButton_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs)
        _currentPage += 1
        ReadCustomerWithQuery()
    End Sub


    Private Sub CreateButton_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs)
        'Teil 1 - Create Customer
        Dim c = New Customer() With {.CompanyName = "", .Country = "Germany"}
        ShowCustomerDetailView()
        _customerDetailView.DataContext = c
    End Sub

    Private Sub _customerDetailView_Closed() Handles _customerDetailView.Closed
        Dim c = CType(_customerDetailView.DataContext, Customer)
        If c IsNot Nothing Then
            'Teil 2 - Create Customer
            _context.AddToCustomerMenge(c) '_context.AddObject("Customer", c)
            _context.BeginSaveChanges(AddressOf CreateSaveChangesComplete, c)
            StatusText.Text = "Erzeugen ..."
        End If
    End Sub

    Private Sub CreateSaveChangesComplete(ByVal result As IAsyncResult)
        Try
            _context.EndSaveChanges(result)

            _customerCollection.Insert(0, CType(result.AsyncState, Customer))
            MyDataGrid.SelectedIndex = 0

            StatusText.Text = "Ready! Kunde " & _
                                 CType(result.AsyncState, Customer).CustomerID.ToString() & " wurde angelegt."

        Catch e As DataServiceRequestException
            StatusText.Text = "Error:" & e.Message.ToString
        End Try
    End Sub

    '<Binding Path="LastName" Mode="TwoWay" 
    '                     NotifyOnValidationError="True" 
    '                     ValidatesOnExceptions="True" />

    Private Sub Page_BindingValidationError(ByVal sender As Object, ByVal e As System.Windows.Controls.ValidationErrorEventArgs) Handles Me.BindingValidationError
        Dim control = CType(e.OriginalSource, Control)

        Select Case e.Action
            Case ValidationErrorEventAction.Added
                control.Background = New SolidColorBrush(Colors.Red)
                control.SetValue(ToolTipService.ToolTipProperty, e.Error.Exception.Message)
            Case ValidationErrorEventAction.Removed
                control.Background = New SolidColorBrush(Colors.White)
                control.SetValue(ToolTipService.ToolTipProperty, Nothing)
        End Select
    End Sub

    Private Sub DeleteButton_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs)
        If MyDataGrid.SelectedItem IsNot Nothing Then
            Try
                Dim customer = CType(MyDataGrid.SelectedItem, Customer)
                _context.DeleteObject(customer)
                _context.BeginSaveChanges(AddressOf DeleteSaveChangesComplete, customer)
                StatusText.Text = "Delete ..."

            Catch ex As DataServiceRequestException
                StatusText.Text = "Error: " + ex.Response.ToString()
            End Try
        End If
    End Sub

    Private Sub DeleteSaveChangesComplete(ByVal result As IAsyncResult)
        Try
            _context.EndSaveChanges(result)
            Dim deletedCustomer = CType(result.AsyncState, Customer)
            _customerCollection.Remove(deletedCustomer)


            StatusText.Text = "Ready! Kunde " & _
                                deletedCustomer.CustomerID.ToString() & " wurde gelöscht."

        Catch e As DataServiceRequestException
            StatusText.Text = "Error:" & e.Message.ToString
        End Try
    End Sub

    Private Sub MyDataGrid_BeginningEdit(ByVal sender As Object, ByVal e As System.Windows.Controls.DataGridBeginningEditEventArgs) Handles MyDataGrid.BeginningEdit
        Dim c = CType(e.Row.DataContext, Customer)
        _context.UpdateObject(c)
    End Sub

    Private Sub UpdateButton_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs)
        Try
            _context.BeginSaveChanges(SaveChangesOptions.Batch, AddressOf BatchSaveChangesComplete, _context)
            StatusText.Text = "Updating ..."

        Catch ex As DataServiceRequestException
            StatusText.Text = "Error: " + ex.Response.ToString()
        End Try
    End Sub

    Private Sub BatchSaveChangesComplete(ByVal result As IAsyncResult)
        Try
            _context.EndSaveChanges(result)

            StatusText.Text = "Ready!" 

        Catch e As DataServiceRequestException
            StatusText.Text = "Error:" & e.Message.ToString
        End Try
    End Sub
End Class