package biz.doodle.ws; // (c) Doodle AG

import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import net.oauth.*;
import net.oauth.server.*;
import biz.doodle.model.*;
import biz.doodle.model.consumer.*;
import biz.doodle.model.user.*;

public class OAuthExampleServlet extends HttpServlet
{
    private final OAuthValidator validator = new SimpleOAuthValidator();
    private final String         realm     = "\"http://doodle.com/api1/\"";

    private void handleOAuthRequest( HttpServletRequest request, HttpServletResponse response )
        throws IOException, OAuthException, URISyntaxException
    {
        if ( request.getPathInfo().equalsIgnoreCase( "/oauth/requesttoken" ) ) {
            OAuthMessage requestMessage = OAuthServlet.getMessage( request, null );
            Consumer doodleConsumer = ModelFactory.getConsumerModel().getConsumer( requestMessage.getConsumerKey() );
            if ( doodleConsumer == null ) {
                throw new OAuthProblemException( "consumer_key_invalid" );
            }
            OAuthConsumer oaConsumer = new OAuthConsumer( null, doodleConsumer.getOauthKey(), doodleConsumer.getOauthSecret(), null );
            OAuthAccessor accessor = new OAuthAccessor( oaConsumer );
            validator.validateMessage( requestMessage, accessor );
            accessor.setProperty( "doodle_get", request.getParameter( "doodle_get" ) );
            OAuthExampleTokensBase.generateRequestToken( accessor );
            response.setContentType( "text/plain" );
            OutputStream out = response.getOutputStream();
            OAuth.formEncode( OAuth.newList( "oauth_token", accessor.requestToken, "oauth_token_secret", accessor.tokenSecret ), out );
            out.close();
        } else if ( request.getPathInfo().equalsIgnoreCase( "/oauth/authorizeConsumer" ) ) {
            if ( request.getMethod().equalsIgnoreCase( "GET" ) ) {
                OAuthMessage requestMessage = OAuthServlet.getMessage( request, null );
                OAuthAccessor accessor = OAuthExampleTokensBase.getRequestAccessor( requestMessage.getToken() );
                try {
                    request.setAttribute( "doodle_get", accessor.getProperty( "doodle_get" ) );
                    getServletContext().getRequestDispatcher( "/mydoodle/consumer/authorize.html" ).forward( request, response );
                } catch ( ServletException se ) {
                    response.sendError( HttpServletResponse.SC_INTERNAL_SERVER_ERROR, se.getMessage() );
                }
            } else if ( request.getMethod().equalsIgnoreCase( "POST" ) ) {
                OAuthAccessor accessor = OAuthExampleTokensBase.getRequestAccessor( request.getParameter( "oauth_token" ) );
                String emailAddress = request.getParameter( "emailAddress" );
                User user = ModelFactory.getUserModel().getUserWithAddress( emailAddress );
                if ( user != null && user.passwordMatches( request.getParameter( "password" ) ) ) {
                    accessor.setProperty( "emailAddress", emailAddress );
                    if ( "GET".equals( request.getParameter( "userId" ) ) ) {
                        accessor.setProperty( "userId", "GET" );
                    }
                    if ( "GET".equals( request.getParameter( "name" ) ) ) {
                        accessor.setProperty( "name", "GET" );
                    }
                    Set<String> initiatedPolls = new HashSet<String>();
                    accessor.setProperty( "initiatedPolls", initiatedPolls );
                    if ( request.getParameterValues( "initiatedPolls" ) != null ) {
                        for ( String operation : request.getParameterValues( "initiatedPolls" ) ) {
                            initiatedPolls.add( operation );
                        }
                    }
                    Set<String> participatedPolls = new HashSet<String>();
                    accessor.setProperty( "participatedPolls", participatedPolls );
                    if ( request.getParameterValues( "participatedPolls" ) != null ) {
                        for ( String operation : request.getParameterValues( "participatedPolls" ) ) {
                            participatedPolls.add( operation );
                        }
                    }
                    response.sendRedirect( request.getParameter( "oauth_callback" ) );
                } else {
                    response.sendRedirect( response.encodeRedirectURL( "/mydoodle/consumer/notAuthorized.html" ) );
                }
            } else {
                response.sendError( HttpServletResponse.SC_BAD_REQUEST );
            }
        } else if ( request.getPathInfo().equalsIgnoreCase( "/oauth/accesstoken" ) ) {
            OAuthMessage requestMessage = OAuthServlet.getMessage( request, null );
            OAuthAccessor accessor = OAuthExampleTokensBase.getRequestAccessor( requestMessage.getToken() );
            validator.validateMessage( requestMessage, accessor );
            OAuthExampleTokensBase.generateAccessToken( accessor );
            response.setContentType( "text/plain" );
            OutputStream out = response.getOutputStream();
            OAuth.formEncode( OAuth.newList( "oauth_token", accessor.accessToken, "oauth_token_secret", accessor.tokenSecret ), out );
            out.close();
        } else {
            response.sendError( HttpServletResponse.SC_BAD_REQUEST );
        }
    }

    @Override
    public void doGet( HttpServletRequest request, HttpServletResponse response )
    {
        try {
            try {
                if ( request.getPathInfo().startsWith( "/oauth/" ) ) {
                    handleOAuthRequest( request, response );
                } else {
                    OAuthMessage requestMessage = OAuthServlet.getMessage( request, null );
                    OAuthAccessor accessor = OAuthExampleTokensBase.getAccessAccessor( requestMessage.getToken() );
                    validator.validateMessage( requestMessage, accessor );
                    // handleAuthenticGet( accessor, request, response );
                }
            } catch ( OAuthException oae ) {
                response.setStatus( HttpServletResponse.SC_UNAUTHORIZED );
                response.setHeader( "WWW-Authenticate", "OAuth realm=" + realm );
                response.getWriter().append( oae.getMessage() );
            } catch ( URISyntaxException use ) {
                response.sendError( HttpServletResponse.SC_INTERNAL_SERVER_ERROR );
            }
        } catch ( IOException ioe ) {
            // yep, nothing!
        }
    }
}
