<?php

// HTTP_RAW_POST_DATA aus php://input einlesen (postBody im AJAX-Request)
$request = json_decode(file_get_contents('php://input'), true);

// Grundgeruest der JSON-Antwort
$response = array(
	"retry" => array(),
	"completed" => array(),
	"data" => array(),
	"times" => array(time()),
	"version" => 1
);

// Was wurde angefordert?
$scope = $request["request"][0];

switch($scope) {
	// Controller fr den Scope timeserver
	case "timeserver":
		// Datum immer setzen
		$response["data"]["Datum"] = date("d.m.Y");
		// autom. Seed seit PHP 4.2
		if (rand(0,1)) {
		    // Uhrzeit nur manchmal setzen und dann auch den Request abschliessen
			$response["data"]["Uhrzeit"] = date("H:i:s");
			$response["completed"][] = $scope;
		} else {
			// sonst den Client noch mal pollen lassen
			$response["retry"][] = $scope;
		}
	break;
}

// JSON-Ausgabe
echo json_encode($response);

// Absichtlich kein PHP-End-Tag, um invalide Whitespaces nach der JSON-Struktur zu vermeiden!
