/*! Copyright (C) 2007,2008 Deutsche Telekom AG / Products & Innovations */
/*! test-fec.js */

/* Diese Funktionsbibliothek gehoert zum Unit Test Framework testcase
 * und testet die Funktionen des FEC (Frontendcontroller).
 * Die aufrufende HTML Datei ist unter services/test/jsunit.html 
 * Doku unter: file:///N:/CFD_PESAEKI/2-ProjectScopeManagement/2-ScopeDefinition/Entwicklung/Software/javascript/testcase-2.0-alpha/doc/index.html     
 */
 
/* ___________ allgemeine Util Klasse______________________ */
var util = {
	pcMin: '{ "scopes":["logindaten"] }',
	pcFull: '{ "scopes":["logindaten","kontaktdaten"], "paramsLoad":["merge"], "paramsSend":["change"], "parameter":{ "reset":"rufnummer" }, "pageid":"UC016_02", "gotos":{"next":"index.html"} }',
	responseMin: { "retry":[], "data":{ "Toid":"123456789011","Loginname":"kunde-1@t-online.de","Kundennummer":"1000000011" }, "times":[1187864472526,1187864472558,1187864472558], "completed":["logindaten"], "version":1 },
	requestMin: { "referer": "/yaf4ajn/", "times": [1214839989959], "request": ["kontaktdaten"] },
	// Default Cookie mit " wie vom Server gespeichert
	cookieDefault: '"reg:0,ident:1,ml:1,gl:1,sl:0,vl:1,el:1,wm:0,t:20080402142832,h:ThAMUheEHPIcoBBjLG8Hd/GQOOQ="',
	htmlForm: '<div class="form"><form id='+fec.config.htmlIdForm+'><fieldset><table id=table><tr id=tr><td>Text:</td><td id=td><input id="'+fec.config.htmlIdDataPrefix + 'Param1" name="'+fec.config.htmlIdDataPrefix + 'Param1"/></td><td/></tr></table></fieldset></form></div>',
	testString: '',
	log: function(s) {
		$('log').insert({'top':'- '+s+'<br/>\n'});
	},
	cleanLog: function(s) {
		$('log').update('');
	},
	debug: function(s) {
		if (Prototype.Browser.Gecko) {
			console.log(s);
		}
	},
	findLog: function(s) {
		return ($('log').innerHTML.search(s) > -1 );
	},
	findHtml: function(s,ele) {
		if (ele) {
			return (ele.innerHTML.search(s) > -1 );
		} else {
			return ($$('body')[0].innerHTML.search(s) > -1 );
		}
	},
	addHtmlTmp: function(html) {
		if ($('tmp')) {
			$('tmp').insert({'bottom':'\n'+html+'\n'});
		} else {
			$$('body')[0].insert({'bottom':'<div id="tmp" class="box naked">\n'+html+'\n</div>'});
		}
	},
	removeHtmlTmp: function() {
		if($('tmp')) {
			$('tmp').remove();
		}
	}
};

/* ___________ spezielle Konfigurationen zum Testen ______ */
fec.errorCode.ERKUND = 'Ihre Daten konnten nicht vollst�ndig ermittelt werden.'; 
fec.errorConfig.ERKUND = {
		'head' : 'Hinweis',
		'css'  : 'info'
};
fec.errorCode.EPFLICHT = 'Im Feld #{0} muss etwas eingegeben werden.';
var lxurls = {
		'default'                   : 'index.html'
};			

/* ___________ Test fec Klasse aus fec.js ______________ */
TestCaseUtil.Fec = TestCase.create({
	name: "TestCaseUtil.Fec",
	test_initialize: function() {
		this.mockUp(fec.base, 'dataLoad', function() { util.log('test_initialize dataload');return; });	
		this.mockUp(fec.util, 'submitObserver', function() { util.log('test_initialize submitObserver');return; });	
		fecPagecontrol = util.pcMin;
		fec.base.initialize();
		this.assertTrue(fec.main !== undefined);
		this.assertTrue(fec.pageControl !== undefined);
		this.assertTrue(util.findLog('test_initialize dataload'));
		this.assertFalse(util.findLog('test_initialize submitObserver'));
		// mit Form
		util.addHtmlTmp(util.htmlForm);
		fec.base.initialize();
		this.assertTrue(util.findLog('test_initialize submitObserver'));
				
		this.undoMockup(fec.base, 'dataLoad');  	
		this.undoMockup(fec.util, 'submitObserver');  	
		fec.main = undefined;
		fecPagecontrol = undefined;
		fec.pageControl = undefined;
		vspRedirs = undefined;
		util.removeHtmlTmp();
		util.log('test_initialize = ok');		
	},
	test_dataload: function() {
		// funktion hat keine eigene Logik 
		util.log('test_dataload = ok');		
	},
	test_datasend: function() {
		// funktion hat keine eigene Logik 
		util.log('test_datasend = ok');		
	}
});

/* ___________ Test FecMain Klasse aus fec.js ______________ */
function fecHookCheckFormLogindaten() { return false; } // <- Mock fuer test_checkForm
function fecHookInitially() { util.log('hook-function fecHookInitially'); }
function fecHookFinally() { util.log('hook-function fecHookFinally'); }
function fecHookSetDataToid() { util.log('hook-function fecHookSetData'); }
function executeVoid() { util.log('hook-function executeVoid'); }
TestCaseUtil.FecMain = TestCase.create({
	name: "TestCaseUtil.FecMain",
	// fec.main wird in jeder Testfunktion benoetigt
	setUp: function() {    fec.main = new FecMain(); },
	tearDown: function() { 
		fec.main = undefined;	
		util.removeHtmlTmp();
	},
	test_errorAdd: function() {
		// normale Fehleranzeige
		fec.main.errorAdd('E_BELIEBIGER_FEHLER');
		this.assertTrue($('vspScopeFehlerError'));
		this.assertTrue(util.findHtml('warnung.png', $('vspScopeFehlerInfo')));
		this.assertTrue(util.findHtml(fec.errorCode.EUNEXP, $('vspScopeFehler')));
		fec.main.errorAdd('E_BELIEBIGER_FEHLER', 'spezieller Fehlertext');
		this.assertTrue(util.findHtml('spezieller Fehlertext', $('vspScopeFehler')));
		this.assertVisible($('vspScopeFehler'));
		this.assertVisible($('vspScopeFehlerError'));
		$('vspScopeFehler').update('');
		
		// speziel konfigurierter Fehler
		fec.main.errorAdd('ERKUND');
		this.assertTrue($('vspScopeFehlerInfo'));
		this.assertTrue(util.findHtml('Hinweis',$('vspErrorHeaderInfo')));
		this.assertTrue(util.findHtml('info.gif',$('vspScopeFehlerInfo')));
		this.assertTrue(util.findHtml('Ihre Daten konnten nicht',$('vspScopeFehlerInfo')));
		this.assertVisible($('vspScopeFehler'));
		this.assertVisible($('vspScopeFehlerInfo'));
		$('vspScopeFehler').update('');
		
		// Error aus fec
		fec.main.errorAdd('', fec.msg.FE002);
		this.assertTrue(util.findHtml('pageControl String nicht valide', $('vspScopeFehlerInfo')));
		$('vspScopeFehler').update('');

		// mit Ersetzung ein String
		fec.main.errorAdd('EPFLICHT', 'Feldname');
		this.assertTrue(util.findHtml('Im Feld Feldname', $('vspScopeFehlerInfo')));
		$('vspScopeFehler').update('');

		// mit Ersetzung ein String
		fec.main.errorAdd('EPFLICHT', 'Feldname');
		this.assertTrue(util.findHtml('Im Feld Feldname', $('vspScopeFehlerInfo')));
		$('vspScopeFehler').update('');

		// {"PAGE":[ {"Code":"ERKUND","Args":[]}, {"Code":"EABONZB2","Args":["Prod1", "Prod2"]}, {"Code":"E37XXX","Args":[]} ]}

		// mit Ersetzung mehrerer Strings (zuviele)
		fec.main.errorAdd( {"Code":"EPFLICHT","Args":["TestProdukt-1", "TestProdukt-2", "TestProdukt-3"]} ,'PAGE'); 
		this.assertTrue(util.findHtml('Im Feld TestProdukt-1', $('vspScopeFehlerInfo')));
		this.assertFalse(util.findHtml('TestProdukt-2', $('vspScopeFehlerInfo')));
		$('vspScopeFehler').update('');

		// mehrere gleiche Fehlermeldungen mit Ersetzen
		var errors = $A([{"Code":"EPFLICHT","Args":["Feld1"]}, {"Code":"EPFLICHT","Args":["Feld2"]}]);
		errors.each(function(err) {
			fec.main.errorAdd(err,'PAGE'); 
		}.bind(this));		
		this.assertTrue(util.findHtml('Feld1',$('vspScopeFehlerInfo')));
		this.assertTrue(util.findHtml('Feld2',$('vspScopeFehler')));
		$('vspScopeFehler').update('');

		util.log('test_errorAdd = ok');
	},
	test_initErrorBox: function() {
		// Error Box
		this.assertEquals($('vspScopeFehlerError'),null);
		fec.main.initErrorBox('eRRoR');
		this.assertTrue($('vspScopeFehlerError'));
		this.assertTrue($('vspErrorListError'));
		this.assertTrue(util.findHtml('warnung.png',$('vspScopeFehler')));
		$('vspScopeFehler').update('');

		// Info Box
		this.assertEquals($('vspScopeFehlerInfo'),null);
		fec.main.initErrorBox('iNfO');
		this.assertTrue($('vspScopeFehlerInfo'));
		this.assertTrue($('vspErrorListInfo'));
		this.assertTrue(util.findHtml('info.gif',$('vspScopeFehler')));
		$('vspScopeFehler').update('');
		
		// Clear
		fec.main.errorAdd('E_BELIEBIGER_FEHLER');
		this.assertHasChild($('vspErrorListError'),'li');
		fec.main.initErrorBox('ErroR',true);
		this.assertHasNoChild($('vspErrorListError'),'li');

		util.log('test_initErrorBox = ok');
	},
	test_initErrorList: function() {
		$('vspScopeFehler').remove();
		fec.main.initErrorList();
		this.assertTrue($('vspScopeFehler'));
		this.assertHidden($('vspScopeFehler'));
		fec.main.initErrorList();
		this.assertEqual($('vspScopeFehler').innerHTML,'');
		util.log('test_initErrorList = ok');
	},
	test_checkForm: function() {
		// Normal, ruft checkFormLogindaten von hier auf
		fec.pageControl = new FecPageControl(util.pcMin);
		this.assertFalse(fec.main.checkForm());
		// checkFormTestjsunit -> true
		fec.pageControl = new FecPageControl('{ "scopes":["testjsunit"] }');
		this.assertTrue(fec.main.checkForm());
		// Validate Param auf false		
		fec.pageControl = new FecPageControl(util.pcMin);
		fec.pageControl.setParameter('validate',false);
		this.assertTrue(fec.main.checkForm());

		fec.pageControl = undefined;
		util.log('test_checkForm = ok');
	},
	test_misc: function() {
		// Muessen nur durchlaufen
		fec.main.scrollToBottom();
		fec.main.scrollToTop();
		// getAjaxRequestUrl
		fec.main.staticOn = false;
		this.assertEqual(fec.main.ajaxRequestUrl, fec.main.getAjaxRequestUrl('load'));
		this.assertEqual(fec.main.ajaxRequestUrl, fec.main.getAjaxRequestUrl('send'));
		fec.main.staticOn = true;
		this.assertMatch('.txt', fec.main.getAjaxRequestUrl('load'));
		this.assertMatch('.txt.send', fec.main.getAjaxRequestUrl('send'));
		// disableForm
		fec.main.disableForm(true);
		util.addHtmlTmp(util.htmlForm);
		this.assertFalse($(fec.util.eleId('Param1')).disabled);
		fec.main.disableForm(true);
		this.assertTrue($(fec.util.eleId('Param1')).disabled);
		fec.main.disableForm(false);
		this.assertFalse($(fec.util.eleId('Param1')).disabled);
		// getReferer
		this.assertMatch('\\S*jsunit.html', fec.main.getReferer() );
		// isValueInArray
		this.assertFalse(fec.main.isValueInArray(undefined,"a"));
		this.assertFalse(fec.main.isValueInArray("a","a")); // kein Array
		this.assertFalse(fec.main.isValueInArray(["a","b"],"c"));
		this.assertTrue(fec.main.isValueInArray(["a","b"],"a"));
		this.assertTrue(fec.main.isValueInArray(["a"],"a"));
		// showContainer
		fec.main.showContainer();

		util.log('test_misc = ok');
	},
	test_disableSubmitButtons: function() {
		util.addHtmlTmp(util.htmlForm);
		fec.main.disableSubmitButtons(true);
		$(fec.config.htmlIdForm).insert({'bottom':'<div id=buttons><input type="button" value="Zurücksetzen" id="but1" /><input type="button" title="Abbrechen" value="Abbrechen" id="but2" /><input type="submit" title="Weiter" value="Weiter" id="but3" /></div>'});		
		this.assertMatch('Zurücksetzen', $('but1').value);
		this.assertMatch('Abbrechen', $('but2').value);
		this.assertMatch('Weiter', $('but3').value);
		this.assertFalse($('but1').disabled);
		this.assertFalse($('but2').disabled);
		this.assertFalse($('but3').disabled);
		fec.main.disableSubmitButtons(true);
		this.assertMatch('Bitte warten ..', $('but1').value);
		this.assertMatch('Bitte warten ..', $('but2').value);
		this.assertMatch('Bitte warten ..', $('but3').value);
		this.assertTrue($('but1').disabled);
		this.assertTrue($('but2').disabled);
		this.assertTrue($('but3').disabled);
		fec.main.submitButtons[2] = ''; // manipuliert but2 zu default weiter
		fec.main.disableSubmitButtons(false);
		this.assertMatch('Zurücksetzen', $('but1').value); 
		this.assertMatch('Weiter', $('but2').value);
		this.assertMatch('Weiter', $('but3').value);
		this.assertFalse($('but1').disabled);
		this.assertFalse($('but2').disabled);
		this.assertFalse($('but3').disabled);

		util.log('test_disableSubmitButtons = ok');
	},
	test_getRequestBodyParams: function() {
		// ohne Params
		fec.pageControl = new FecPageControl(util.pcMin);
		this.assertMatch('', fec.main.getRequestBodyParams('load'));
		this.assertMatch('', fec.main.getRequestBodyParams('send'));
		// Loads
		fec.pageControl = new FecPageControl('{ "scopes":["logindaten"], "paramsLoad":["init"] }');
		this.assertMatch('"action": "init"', fec.main.getRequestBodyParams('load'));
		fec.pageControl = new FecPageControl('{ "scopes":["logindaten"], "paramsLoad":["finish"] }');
		this.assertMatch('"action": "finish"', fec.main.getRequestBodyParams('load'));
		fec.pageControl = new FecPageControl('{ "scopes":["logindaten"], "paramsLoad":["merge"] }');
		this.assertMatch('"merge": true', fec.main.getRequestBodyParams('load'));
		// Load relogin
		fec.pageControl = new FecPageControl('{ "scopes":["logindaten"], "paramsLoad":["relogin"] }');
		this.assertMatch('"action": "relogin"', fec.main.getRequestBodyParams('load'));
		util.addHtmlTmp('<input name="fecParamWdywtg" id="fecParamWdywtg" value="test.html" />');
		fec.pageControl = new FecPageControl('{ "scopes":["logindaten"], "paramsLoad":["relogin"] }');
		this.assertMatch('"action": "relogin", "wdywtg": "test.html"', fec.main.getRequestBodyParams('load'));
		// Loads mixed
		fec.pageControl = new FecPageControl('{ "scopes":["logindaten"], "paramsLoad":["finish","merge"] }');
		this.assertMatch('"merge": true, "action": "finish"', fec.main.getRequestBodyParams('load'));
		fec.pageControl = new FecPageControl('{ "scopes":["logindaten"], "paramsLoad":["relogin","merge"] }');
		this.assertMatch('"action": "relogin", "wdywtg": "test.html", "merge": true', fec.main.getRequestBodyParams('load'));
		// Send
		fec.pageControl = new FecPageControl('{ "scopes":["logindaten"], "paramsSend":["change"] }');
		this.assertMatch('"action": "change"', fec.main.getRequestBodyParams('send'));
		fec.pageControl = new FecPageControl('{ "scopes":["logindaten"], "paramsSend":["save"] }');
		this.assertMatch('"action": "save"', fec.main.getRequestBodyParams('send'));
		// Param merge - fuer Opera muss man { und } sauber escapen
		fec.pageControl = new FecPageControl('{ "scopes":["logindaten"], "parameter":{ "reset":"rufnummer" } }');
		this.assertMatch('"parameter": \\{"reset": "rufnummer"\\}', fec.main.getRequestBodyParams('load'));
		fec.pageControl = new FecPageControl('{ "scopes":["logindaten"], "paramsLoad":["init","merge"], "parameter":{ "reset":"rufnummer" } }');
		this.assertMatch('"parameter": \\{"merge": true, "action": "init", "reset": "rufnummer"\\}', fec.main.getRequestBodyParams('load'));
		fec.pageControl = new FecPageControl('{ "scopes":["logindaten"], "paramsSend":["change"], "parameter":{ "reset":"buchungskonto" } }');
		this.assertMatch('"parameter": \\{"action": "change", "reset": "buchungskonto"\\}', fec.main.getRequestBodyParams('send'));
		
		fec.pageControl = undefined;
		util.log('test_getRequestBodyParams = ok');
	},
	test_getRequestBody: function() {
		var tmp = "";
		fec.pageControl = new FecPageControl(util.pcFull);
		// laden
		tmp = fec.main.getRequestBody('load');
		this.assertMatch('^{.*}$', tmp );
		this.assertMatch('("referer")(:\\s)("\\S*")', tmp );     
		this.assertMatch('("request")(:\\s)(\\["logindaten", "kontaktdaten"\\])', tmp );     
		this.assertMatch('("times")(:\\s)([\\S*])', tmp );
		this.assertMatch('("pageid")(:\\s)("UC016_02")', tmp );
		this.assertNotMatch('data', tmp );
		this.assertTrue(eval('('+ tmp + ')'));

		tmp = fec.main.getRequestBody('load','scopejsunit'); // mit scope
		this.assertMatch('scopejsunit', tmp );     
		
		// senden
		fec.pageControl = new FecPageControl(util.pcMin);
		tmp = fec.main.getRequestBody('send','scopetest');
		this.assertMatch('^{.*}$', tmp );
		this.assertMatch('("referer")(:\\s)("\\S*")', tmp );     
		this.assertMatch('("request")(:\\s)(\\["logindaten"\\])', tmp ); // scopetest wird bei send ignoriert     
		this.assertMatch('("times")(:\\s)([\\S*])', tmp );
		this.assertNotMatch('data', tmp );
		this.assertTrue(eval('('+ tmp + ')'));
		
		util.addHtmlTmp(util.htmlForm);
		tmp = fec.main.getRequestBody('send','scopetest');
		this.assertMatch('"data": \\{"Param1": ""\\}', tmp );
		
		util.log('test_getRequestBody = ok');
	},
	test_serializeElements: function() {
		util.addHtmlTmp(util.htmlForm);
		// leere Inputs
		var html = '<input type="hidden" id="'+fec.util.eleId('Hidden')+'" name="'+fec.util.eleId('Hidden')+'" />'
		 	+ '<input type="radio"    id="'+fec.util.eleId('RadioOption1')+'" name="'+fec.util.eleId('Radio')+'"     class="radio" value="option1" />'
			+ '<input type="radio"    id="'+fec.util.eleId('RadioOption2')+'" name="'+fec.util.eleId('Radio')+'"     class="radio" value="option2" />'
			+ '<input type="text"     id="'+fec.util.eleId('Text')+'"         name="'+fec.util.eleId('Text')+'"      class="medium" maxlength="20" />'
			+ '<input type="text"     id="'+fec.util.eleId('Readonly')+'"     name="'+fec.util.eleId('Readonly')+'"      readonly="readonly" />'
			+ '<input type="text"     id="'+fec.util.eleId('Disabled')+'"     name="'+fec.util.eleId('Disabled')+'"      disabled="disabled" />'
			+ '<input type="checkbox" id="'+fec.util.eleId('Checkbox')+'"     name="'+fec.util.eleId('Checkbox')+'"  class="checkbox" />'
			+ '<input type="password" id="'+fec.util.eleId('Password')+'"     name="'+fec.util.eleId('Password')+'"  size="Länge" maxlength="20" />'
			+ '<input type="button"   value="Button" onclick="void(0)" />'
			+ '<input type="submit"   value="Submit" />'
			+ '<textarea              id="'+fec.util.eleId('Textarea')+'"     name="'+fec.util.eleId('Textarea')+'"  ></textarea>'
			+ '<select id="'+fec.util.eleId('Select')+'" name="'+fec.util.eleId('Select')+'"><option value="option1">Option1</option><option value="option2">Option2</option></select>'
			+ '';
		$('td').insert({'bottom':html});
		var s = $H(fec.main.serializeElements($(fec.config.htmlIdForm).getElements(), true)).toJSON();
		util.debug(s);
		this.assertMatch('{' 
				+ '"'+ fec.util.eleId('Param1')   + '": "", '
				+ '"'+ fec.util.eleId('Hidden')   + '": "", '
				+ '"'+ fec.util.eleId('Text')     + '": "", '
				+ '"'+ fec.util.eleId('Readonly') + '": "", '
				+ '"'+ fec.util.eleId('Checkbox') + '": "false", '
				+ '"'+ fec.util.eleId('Password') + '": "", '
				+ '"'+ fec.util.eleId('Textarea') + '": "", '
				+ '"'+ fec.util.eleId('Select')   + '": "option1"}', s );

		// befuellte Inputs
		$(fec.util.eleId('Hidden')).value = "data";
		$(fec.util.eleId('RadioOption1')).checked = true;
		$(fec.util.eleId('Text')).value = "data";
		$(fec.util.eleId('Readonly')).value = "data";
		$(fec.util.eleId('Disabled')).value = "data"; // disabled wird niemals ausgelesen
		$(fec.util.eleId('Checkbox')).checked = true;
		$(fec.util.eleId('Password')).value = "data";
		$(fec.util.eleId('Textarea')).value = "data";
		$(fec.util.eleId('Select')).selectedIndex = 1;
		s = $H(fec.main.serializeElements($(fec.config.htmlIdForm).getElements(), true)).toJSON();
		util.debug(s);
		this.assertMatch('{'
				+ '"'+ fec.util.eleId('Param1')   + '": "", '
				+ '"'+ fec.util.eleId('Hidden')   + '": "data", '
				+ '"'+ fec.util.eleId('Radio')    + '": "option1", '
				+ '"'+ fec.util.eleId('Text')     + '": "data", '
				+ '"'+ fec.util.eleId('Readonly') + '": "data", '
				+ '"'+ fec.util.eleId('Checkbox') + '": "true", '
				+ '"'+ fec.util.eleId('Password') + '": "data", '
				+ '"'+ fec.util.eleId('Textarea') + '": "data", '
				+ '"'+ fec.util.eleId('Select')   + '": "option2"}', s ); 
			
		util.log('test_serializeElements = ok');
	},
	test_getUriControlParams: function() {
		// default
		this.assertEqual(0, fec.main.getUriControlParams().size());
		// nicht gueltige Params
		this.mockUp(fec.util, 'getQueryParams', function() { return $H({ 'url': 'jsunit.html','iframe':'true' }); });	
		this.assertEqual(0, fec.main.getUriControlParams().size());
		// gueltige Params
		this.mockUp(fec.util, 'getQueryParams', function() { return $H({ 'id': 'ucId','confirmid':'ucConfirmid','regid':'ucRegid','wdywtg':'urlWdywtg','wdycf':'urlWdycf' }); });	
		this.assertEqual(5, fec.main.getUriControlParams().size());
		util.log(fec.main.getUriControlParams().toJSON());
		this.assertTrue(util.findLog('{"Id": "ucId", "Confirmid": "ucConfirmid", "Regid": "ucRegid", "Wdywtg": "urlWdywtg", "Wdycf": "urlWdycf"}'));
		this.undoMockup(fec.util, 'getQueryParams');  	
		util.log('test_getUriControlParams = ok');
	},
	test_getRequestData: function() {
		var rd;
		// default
		rd = fec.main.getRequestData();
		this.assertEqual('', rd);
		// load mit Form
		util.addHtmlTmp(util.htmlForm);
		rd = fec.main.getRequestData();
		this.assertEqual('{"Param1": ""}', rd);
		// load mit Form und Params
		this.mockUp(fec.main, 'getUriControlParams', function() { return $H({ 'id': 'ucsw000','wdywtg':'jsunit.html' }); });	
		rd = fec.main.getRequestData();
		this.assertEqual('{"Param1": "", "id": "ucsw000", "wdywtg": "jsunit.html"}', rd);
		this.assertNotMatch(fec.config.jsSetterPrefix, rd);
		// save mit Form und Params
		rd = fec.main.getRequestData('send');
		this.assertEqual('{"Param1": "", "id": "ucsw000", "wdywtg": "jsunit.html"}', rd);
		this.assertTrue($(fec.util.eleId('Param1')).disabled == true);

		this.undoMockup(fec.main, 'getUriControlParams');  	
		util.log('test_getRequestData = ok');
	},
	test_getVspDataFormElements: function() {
		var fe;
		// default (ohne Form)
		fe = fec.main.getVspDataFormElements();
		this.assertEqual(0, fe.size());
		// mit Form
		util.addHtmlTmp(util.htmlForm);
		// Input-Name muss mit vspData anfangen ...
		$('td').insert({'bottom':'<input type=text name=vspFremdesElement id=vspFremdesElement />'});
		fe = fec.main.getVspDataFormElements();
		this.assertEqual(1, fe.size());
		this.assertEqual('{"'+fec.util.eleId('Param1')+'": ""}', fe.toJSON());
		this.assertNotMatch('vspFremdesElement', fe.toJSON());

		util.log('test_getVspDataFormElements = ok');
	},
	test_setElementValue: function() {
		var rv;
		// default
		rv = fec.main.setElementValue();
		this.assertFalse(rv);
		util.addHtmlTmp(util.htmlForm);
		rv = fec.main.setElementValue('','value');
		this.assertFalse(rv);
		rv = fec.main.setElementValue('key','value');
		this.assertFalse(rv);
		// mit Form
		rv = fec.main.setElementValue(fec.util.eleId('Param1'),'value');
		this.assertEquals('value',$(fec.util.eleId('Param1')).value);

		util.log('test_setElementValue = ok');
	},
	test_showSpinner: function() {
		this.mockupEffects();
		this.mockUp(fec.main, 'showScope', function(scope,show) { util.log('scope: '+scope+' | showSpinner: '+show ); });	
		// default
		fec.main.showSpinner();
		fec.main.showSpinner('jsunitLb1');
		this.assertTrue(util.findLog('scope: '+fec.config.htmlIdScopePrefix+'LoadJsunitLb1 | showSpinner: false'));
		fec.main.showSpinner('jsunitLb2',true);
		this.assertTrue(util.findLog('scope: '+fec.config.htmlIdScopePrefix+'JsunitLb2 | showSpinner: false'));
		this.assertTrue(util.findLog('scope: '+fec.config.htmlIdLoaderPrefix+'JsunitLb2 | showSpinner: true'));
		fec.main.showSpinner(['jsunitLb3','JsunitLb4'],true);
		this.assertTrue(util.findLog('scope: '+fec.config.htmlIdScopePrefix+'JsunitLb3 | showSpinner: false'));
		this.assertTrue(util.findLog('scope: '+fec.config.htmlIdLoaderPrefix+'Jsunitlb4 | showSpinner: true'));

		this.undoMockup(fec.main, 'showScope');  	
		this.undoEffectsMockup();
		util.log('test_showSpinner = ok');
	},
	test_showScope: function() {
		this.assertFalse(fec.main.showScope());
		util.addHtmlTmp(util.htmlForm);
		this.assertTrue(fec.main.showScope(fec.config.htmlIdForm));
		this.assertFalse($(fec.config.htmlIdForm).visible());
		this.assertTrue(fec.main.showScope(fec.config.htmlIdForm,true));
		this.assertTrue($(fec.config.htmlIdForm).visible());
		this.assertTrue(fec.main.showScope(fec.config.htmlIdForm,false));
		this.assertFalse($(fec.config.htmlIdForm).visible());

		util.log('test_showScope = ok');
	},
	test_processResponseTimes: function() {
		var vspData = util.responseMin;
		this.assertEqual(3,vspData.times.size());
		fec.main.processResponseTimes(vspData);
		this.assertEqual(4,vspData.times.size());
		util.log('test_processResponseTimes = ok');
	},
	test_replaceWerteInDOM: function() {
		var vspData = util.responseMin;
		util.removeHtmlTmp();
		util.addHtmlTmp(util.htmlForm);
		fec.main.replaceWerteInDOM(vspData.data);
		// teste hooks
		this.assertTrue(util.findLog('fecHookInitially'));
		this.assertTrue(util.findLog('fecHookFinally'));
		this.assertTrue(util.findLog('fecHookSetData'));
		// teste data 
		var data = { "Id":"9876","Tonlineid":"1234567890","Loginname":"kunde@email.de","Testnummer":"1000000011","Namen":["Name1","Name2"]};
		$('td').insert({'bottom':'<input type=text name='+fec.util.eleId('Tonlineid')+' id='+fec.util.eleId('Tonlineid')+' />'});
		$('td').insert({'bottom':'<input type=text name='+fec.util.eleId('testnummer')+' id='+fec.util.eleId('testnummer')+' />'});
		$('td').insert({'bottom':'<input type=text name='+fec.util.eleId('Loginname')+' id='+fec.util.eleId('Loginname')+' />'});
		$('td').insert({'bottom':'<input type=text name='+fec.util.eleId('Loginname1')+' id='+fec.util.eleId('Loginname1')+' />'});
		$('td').insert({'bottom':'<input type=text name='+fec.util.eleId('Loginname2')+' id='+fec.util.eleId('Loginname2')+' />'});
		$('td').insert({'bottom':'<input type=text name='+fec.util.eleId('Id')+' id='+fec.util.eleId('Id')+' />'});
		$('td').insert({'bottom':'<input type=text name='+fec.util.eleId('Id1')+' id='+fec.util.eleId('Id1')+' />'});
		$('td').insert({'bottom':'<input type=text name='+fec.util.eleId('Namen')+' id='+fec.util.eleId('Namen')+' />'});
		fec.main.replaceWerteInDOM(data);
		this.assertEqual('1234567890',$(fec.util.eleId('Tonlineid')).value);			// normales update
		//this.assertEqual('',$(fec.util.eleId('testnummer')).value); 					// klein geschrieben, wird im ie trotzdem ersetzt -> finde nur http://webbugtrack.blogspot.com/2007/09/bug-154-getelementbyid-is-not-case.html  
		this.assertEqual('kunde@email.de',$(fec.util.eleId('Loginname')).value);		// normales update
		this.assertEqual('kunde@email.de',$(fec.util.eleId('Loginname1')).value);	// inkrement +1
		this.assertEqual('kunde@email.de',$(fec.util.eleId('Loginname2')).value);	// inkrement +2
		this.assertEqual('9876',$(fec.util.eleId('Id')).value);						// normales update
		this.assertEqual('',$(fec.util.eleId('Id1')).value);							// id inkrement wird nicht geupdatet 
		this.assertEqual('Name1,Name2',$(fec.util.eleId('Namen')).value);			// keys mit en werden als erstes verarbeiten, kann man so schlecht testen 
		
		util.log('test_replaceWerteInDOM = ok');
	},
	test_processResponse: function() {
		this.mockupEffects();
		var rStr = Object.toJSON(util.responseMin);
		this.mockUp(fec.util, 'redirect', function(url,delay) { util.log('test_processResponse url: ' + url);return; });
		// leere response - es gibt keine Fehlerseite mehr wenn Response leer ist
		// fec.main.processResponse('load','');
		// this.assertTrue(util.findLog('processResponse_noResponse'));
		//  redirect im response
		var r = '{ "redirect":"redirect-processResponse.html" }';
		fec.main.processResponse('load',r);
		this.assertTrue(util.findLog('redirect-processResponse.html'));
		// container
		util.addHtmlTmp('<span id=container style="display:none"></span>');
		util.addHtmlTmp('<span id=containerWarten ></span>');
		fec.main.processResponse('load',rStr);
		this.assertTrue($('container').visible());
		this.assertFalse($('containerWarten').visible());
		// gotoPage
		r = '{ "gotoPage":"redirect-gotoPage-processResponse.html" }';
		util.addHtmlTmp(util.htmlForm);
		$('td').insert({'bottom':'<input type=submit id=vspSubmit disabled />'});
		fec.main.processResponse('load',r);
		this.assertTrue(util.findLog('redirect-gotoPage-processResponse.html'));
		this.assertFalse($('vspSubmit').disabled);
		// retry
		this.mockUp(fec.util, 'delay', function(obj,time) { util.log('test_processResponse delay time: ' + time + ' func: ' + obj.toString());return; });
		r = '{ "retry":["kontaktdaten"] }';
		fec.main.processResponse('load',r);
		this.assertTrue(util.findLog('test_processResponse delay time: 1000'));
		this.assertTrue(util.findLog('fec.main.getServerData'));
		r = '{ "retry":["kontaktdaten"], "wait":200 }';
		fec.main.processResponse('send',r);
		this.assertTrue(util.findLog('fec.main.getServerData'));
		this.assertTrue(util.findLog('fec.base.dataSend'));
		// completed
		r = '{ "completed":["kontaktdaten"] }';
		util.addHtmlTmp('<span id='+fec.config.htmlIdScopePrefix+'Kontaktdaten style="display:none"></span>');
		util.addHtmlTmp('<span id='+fec.config.htmlIdLoaderPrefix+'Kontaktdaten></span>');
		fec.main.processResponse('load',r);
		this.assertTrue($(fec.config.htmlIdScopePrefix+'Kontaktdaten').visible());
		this.assertFalse($(fec.config.htmlIdLoaderPrefix+'Kontaktdaten').visible());
		util.removeHtmlTmp();
		// errors load
		this.mockUp(fec.main, 'processResponseError', function() { return false; });
		r = '{ "data":{ "Input7437":"123456789011"}, "error":{"PAGE":{"ERKUND":""} } }';
		util.addHtmlTmp('<span id='+fec.util.eleId('Input7437')+'></span>');
		util.addHtmlTmp('<div class=ladebalken id=ladebalken9473></div>');
		fec.main.processResponse('load',r);
		this.assertEqual('123456789011',$(fec.util.eleId('Input7437')).innerHTML); // data wird trotzdem verarbeitet
		this.assertHasNoClassName($('ladebalken9473'),'ladebalken');
		this.assertHasClassName($('ladebalken9473'),'ladebalken-error');
		util.removeHtmlTmp();
		// error send
		fec.pageControl = new FecPageControl(util.pcMin);
		util.addHtmlTmp('<span id='+fec.config.htmlIdScopePrefix+'Logindaten style="display:none"></span>');
		util.addHtmlTmp('<span id='+fec.config.htmlIdLoaderPrefix+'Logindaten></span>');
		fec.main.processResponse('send',r);
		this.assertTrue($(fec.config.htmlIdScopePrefix+'Logindaten').visible());
		this.assertFalse($(fec.config.htmlIdLoaderPrefix+'Logindaten').visible());
				
		this.undoMockup(fec.util, 'redirect');  	
		this.undoMockup(fec.util, 'delay');  	
		this.undoMockup(fec.main, 'processResponseError');  	
		this.undoEffectsMockup();
		//fec.pageControl = null;
		util.log('test_processResponse = ok');
	},
	test_getAjaxData: function() {
		this.mockupEffects();
		this.mockUp(Ajax, 'Request', function(obj) { util.log('test_getAjaxData url: ' + obj.toString()); });
		this.assertEqual('',fec.main.getAjaxData('jsunit2578.html'));
		this.assertTrue(util.findHtml('jsunit2578.html'));
		// send
		fec.pageControl = new FecPageControl(util.pcMin);
		this.mockUp(fec.main, 'getAjaxRequestUrl', function() { return 'sendUrl47232'; });
		this.assertTrue(fec.main.sendServerData());
		this.assertTrue(util.findHtml('sendUrl47232'));
		// load void
		this.mockUp(fec.main, 'getAjaxRequestUrl', function() { return 'loadUrl78462'; });
		fec.pageControl = new FecPageControl('{ "scopes":["logindaten"], "paramsLoad":["void"] }');
		util.addHtmlTmp('<span id='+fec.config.htmlIdScopePrefix+'Logindaten style="display:none"></span>');
		util.addHtmlTmp('<span id='+fec.config.htmlIdLoaderPrefix+'Logindaten></span>');
		this.assertTrue(fec.main.getServerData());
		this.assertFalse(util.findHtml('loadUrl78462'));
		this.assertTrue(util.findHtml('executeVoid'));
		this.assertTrue($(fec.config.htmlIdScopePrefix+'Logindaten').visible());
		this.assertFalse($(fec.config.htmlIdLoaderPrefix+'Logindaten').visible());
		// load mit Scope
		util.addHtmlTmp('<span id='+fec.config.htmlIdScopePrefix+'Daten43454 style="display:none"></span>');
		util.addHtmlTmp('<span id='+fec.config.htmlIdLoaderPrefix+'Daten43454></span>');
		fec.main.getServerData('Daten43454');
		this.assertTrue($(fec.config.htmlIdScopePrefix+'Daten43454').visible());
		this.assertFalse($(fec.config.htmlIdLoaderPrefix+'Daten43454').visible());
		// load mehrere Scopes
		this.mockUp(fec.main, 'getRequestBody', 
			function(type,scope) { 
				util.log('test_getAjaxData getRequestBody scope: '+scope);
				return Object.toJSON(util.requestMin); 
		});
		fec.pageControl = new FecPageControl('{ "scopes":["logindaten","kontaktdaten"] }');
		fec.main.getServerData();
		this.assertTrue(util.findHtml('getRequestBody scope: logindaten'));
			
		this.undoMockup(Ajax, 'Request');  	
		this.undoMockup(fec.main, 'getAjaxRequestUrl');  	
		this.undoMockup(fec.main, 'getRequestBody');  	
		this.undoEffectsMockup();
		fec.pageControl = null;
		util.log('test_getAjaxData = ok');
	},
	test_finally: function() {
		util.cleanLog();
	}
});

/* ___________ Test FecMain Klasse aus fec.js ______________ */
TestCaseUtil.SetValues = TestCase.create({
	name: "TestCaseUtil.SetValues",
	test_SetValuesHtml: function() {
		util.addHtmlTmp(util.htmlForm);
		// TD
		fec.valuesFactory.td($('td'),'td-element');
		this.assertEqual($('td').innerHTML, 'td-element');
		fec.valuesFactory.td($('td'), true);
		this.assertEqual($('td').innerHTML, 'Ja');
		fec.valuesFactory.td($('td'), false);
		this.assertEqual($('td').innerHTML, 'Nein');
		// P, SPAN
		fec.valuesFactory.p($('td'),'p-element');
		this.assertEqual($('td').innerHTML, 'p-element');
		fec.valuesFactory.span($('td'),'span-element');
		this.assertEqual($('td').innerHTML, 'span-element');
		//TEXTAREA
		$('td').update('<textarea id='+fec.util.eleId('Param1')+' name='+fec.util.eleId('Param1')+' cols=50 rows=10></textarea>');
		fec.valuesFactory.textarea($(fec.util.eleId('Param1')),'input-textarea-element');
		this.assertEqual($(fec.util.eleId('Param1')).value, 'input-textarea-element');
		//SELECT
		$('td').update('<select id='+fec.util.eleId('Param1')+' name='+fec.util.eleId('Param1')+'><option value=valFoo id=idFoo>foo</option><option value=valBar id=idBar>bar</option></select>');
		fec.valuesFactory.select($(fec.util.eleId('Param1')),'valBar');
		this.assertEqual($(fec.util.eleId('Param1')).value, 'valBar');
		this.assertTrue($('idBar').selected);
		this.assertFalse($('idFoo').selected);
		fec.valuesFactory.select($(fec.util.eleId('Param1')),'valFoo');
		this.assertEqual($(fec.util.eleId('Param1')).value, 'valFoo');
		this.assertFalse($('idBar').selected);
		this.assertTrue($('idFoo').selected);
		
		util.removeHtmlTmp();
		util.log('test_SetValuesHtml = ok');
	},
	test_SetValuesInputs: function() {
		util.addHtmlTmp(util.htmlForm);
		//INPUT - submit
		$('td').update('<input type=submit id='+fec.util.eleId('Param1')+' />');
		var v = fec.valuesFactory.input($(fec.util.eleId('Param1')),'input-submit-element');
		this.assertTrue(v);
		//INPUT - hidden
		$('td').update('<input type=hidden id='+fec.util.eleId('Param1')+' name='+fec.util.eleId('Param1')+' /> <span id="' + fec.util.eleId('Param1') + 'Hidden"></span>');
		fec.valuesFactory.input($(fec.util.eleId('Param1')),'input-hidden-element');
		this.assertEqual($(fec.util.eleId('Param1')).value, 'input-hidden-element');
		this.assertEqual($(fec.util.eleId('Param1Hidden')).innerHTML, 'input-hidden-element');
		//INPUT - password
		$('td').update('<input type=password id=' + fec.util.eleId('Param1') + ' name=' + fec.util.eleId('Param1') + ' />');
		fec.valuesFactory.input($(fec.util.eleId('Param1')),'input-password-element');
		this.assertEqual($(fec.util.eleId('Param1')).value, 'input-password-element');
		//INPUT - text
		$('td').update('<input id=' + fec.util.eleId('Param1') + ' name=' + fec.util.eleId('Param1') + ' />');
		fec.valuesFactory.input($(fec.util.eleId('Param1')),'input-text-element');
		this.assertEqual($(fec.util.eleId('Param1')).value, 'input-text-element');
		//INPUT - checkbox
		$('td').update('<input type=checkbox id=' + fec.util.eleId('Param1') + ' name=' + fec.util.eleId('Param1') + ' value=Ja />');
		fec.valuesFactory.input($(fec.util.eleId('Param1')),'Ja');
		this.assertFalse($(fec.util.eleId('Param1')).checked); // checkbox geht nur mit true / false
		fec.valuesFactory.input($(fec.util.eleId('Param1')),'true');
		this.assertTrue($(fec.util.eleId('Param1')).checked);
		fec.valuesFactory.input($(fec.util.eleId('Param1')),'false');
		this.assertFalse($(fec.util.eleId('Param1')).checked);
		//INPUT - radio
		$('td').update('<input type=radio id=' + fec.util.eleId('ParamJa') + ' name=' + fec.util.eleId('Param1') + ' value=Ja /> <input type=radio id=' + fec.util.eleId('ParamNein') + ' name=' + fec.util.eleId('Param1') + ' value=Nein />');
		fec.valuesFactory.input($(fec.util.eleId('ParamNein')),'Nein');
		this.assertFalse($(fec.util.eleId('ParamJa')).checked);
		this.assertTrue($(fec.util.eleId('ParamNein')).checked);
		
		util.removeHtmlTmp();
		util.log('test_SetValuesInputs = ok');
	},
	test_finally: function() {
		util.cleanLog();
	}
});

/* ___________ Test FecPageControl Klasse aus fec.js ______________ */
TestCaseUtil.FecPageControl = TestCase.create({
  name: "TestCaseUtil.FecPageControl",
  test_initialize: function() {
	fec.main = new FecMain();
	// kein Fehler
	fec.pageControl = new FecPageControl(util.pcMin);
	this.assertTrue(fec.pageControl.pc != false);
	// fehlerhaftes fecPagecontrol
	fec.pageControl = new FecPageControl(null);
	this.assertTrue(util.findHtml('pageControl String nicht valide',$('vspScopeFehler')));
	this.assertTrue(fec.pageControl.pc == false);
	$('vspScopeFehler').remove();
	fec.main = undefined;
	util.log('test_initialize = ok');
  },
  test_setter_getter: function() {
	// setter + getter .. default pc
	fec.pageControl = new FecPageControl(util.pcMin);
	this.assertEqual(fec.pageControl.getScopes()[0], 'logindaten');
	this.assertEqual(fec.pageControl.getControl('paramsLoad'), undefined);
	this.assertEqual(fec.pageControl.getParameter().size(),0);
	fec.pageControl.setParameter('param','jsunit');
	this.assertEqual(fec.pageControl.getParameter().get('param'), 'jsunit');
	fec.pageControl.setParamsLoad(['merge']);
	this.assertEqual(fec.pageControl.getControl('paramsLoad'), ['merge']);
	this.assertEqual(fec.pageControl.getPageId(), '');
	// setter + getter .. pc voll belegt
	fec.pageControl = new FecPageControl(util.pcFull);
	this.assertEqual(fec.pageControl.getScopes().length,2);
	this.assertEqual(fec.pageControl.getControl('paramsLoad'), ['merge']);
	this.assertEqual(fec.pageControl.getControl('paramsSend'), ['change']);
	this.assertEqual(fec.pageControl.getParameter().get('reset'), 'rufnummer');
	// schreibe zusaetzlich in params rein
	fec.pageControl.setParameter('param','jsunit');
	// beide werte sind noch da:
	this.assertEqual(fec.pageControl.getParameter().get('reset'), 'rufnummer');
	this.assertEqual(fec.pageControl.getParameter().get('param'), 'jsunit');
	// schreibe neues paramsLoad
	fec.pageControl.setParamsLoad(['paramLoad']);
	this.assertEqual(fec.pageControl.getControl('paramsLoad'), ['paramLoad']);
	// scope als String
	fec.pageControl = new FecPageControl('{ "scopes":"logindaten" }');
	this.assertEqual(fec.pageControl.getScopes()[0], 'logindaten');
	// setControl
	fec.pageControl.setControl('paramsSend', ['send']);
	this.assertEqual(fec.pageControl.getControl('paramsSend'), ['send']);
	fec.pageControl.setControl('paramsLoad', 'load');
	this.assertEqual(fec.pageControl.getControl('paramsLoad'), ['load']);
	
	// aufraeumen
	fec.pageControl = undefined;
	util.log('test_setter_getter = ok');
  },
  test_getGotoUrl_Page_id: function() {
	fec.pageControl = new FecPageControl(util.pcFull);
	// gotoUrl
	this.assertEqual(fec.pageControl.getGotoUrl('test.html'), 'test.html');
	this.assertEqual(fec.pageControl.getGotoUrl('next'), 'index.html');
	this.assertTrue(fec.pageControl.getGotoUrl('undefined').search('errid=getGoto')>-1);
	// gotoPage
	this.assertEqual(fec.pageControl.getGotoPage(), '');
	fec.pageControl.setGotoPage('index.html');
	this.assertEqual(fec.pageControl.getGotoPage(), 'index.html');
	// pageid
	this.assertEqual(fec.pageControl.getPageId(), 'UC016_02');
	fec.pageControl = undefined;
	util.log('test_getGotoUrl_Page_id = ok');
  },
  test_processErrorConfig: function() {
	// Default Einstellungen
	this.assertEqual(fec.errorConfig['ERKUND'].head,'Hinweis');
	this.assertEqual(fec.errorConfig['ERKUND'].css,'info');
	var tmpErrorConfig = Object.clone(fec.errorConfig);
	// Seitenspezifische error-Einstellungen ueber pc
	var pc = '{ "scopes":["logindaten"], "errorconfig": { "ERKUND":{"head":"HinweisJsUnit","css":"jsunit"}, "E37P3F":{"head":"Hinweis:","css":"info"} } }';
	fec.pageControl = new FecPageControl(pc);
	this.assertEqual(fec.errorConfig['ERKUND'].head,'HinweisJsUnit');
	this.assertEqual(fec.errorConfig['ERKUND'].css,'jsunit');
	
	fec.errorConfig = tmpErrorConfig;
	fec.pageControl = undefined;
	util.log('test_processErrorConfig = ok');
	},
	test_finally: function() {
		util.cleanLog();
	}
});

/* ___________ Test fec.cookies Klasse aus fec.js ______________ */
TestCaseUtil.FecForm = TestCase.create({
  name: "TestCaseUtil.FecForm",
  test_initFormValidation: function() {
	fec.main = new FecMain(); // einmal ausfuehren wegen vspFormError init
	fec.main = undefined;
	// kein vspFormError, Einsetzung nach H2
	fec.form.initFormValidation();
	this.assertEqual(fec.form.errorCount,0);
	this.assertEqual(fec.form.isValid,true);
	this.assertTrue($('vspFormError') !== null);
	this.assertHasClassName($('vspFormError'),'error');
	this.assertFalse($('vspFormError').visible());
	$('vspFormError').remove();
	util.log('test_initFormValidation = ok');
  },
  test_setclearErrorInDom: function() {
	fec.form.initFormValidation();
	// Fehler hinzufuegen ..
	util.addHtmlTmp(util.htmlForm);
  	fec.form.setErrorInDom($(fec.util.eleId('Param1')),"Param1-Fehler");
	this.assertTrue($('vspFormErrorList').innerHTML !== '');
	this.assertTrue(util.findHtml('Param1-Fehler',$('vspFormError')));
	this.assertHasClassName($('tr'),'error');
	this.assertFalse(fec.form.isValid);
	this.assertEqual(fec.form.errorCount,1);
	// Fehler wieder entfernen ..
	fec.form.clearErrorsInDom();
	this.assertHasNoClassName($('tr'),'error');
	this.assertTrue($('vspFormErrorList').innerHTML === '');
	this.assertFalse($('vspFormError').visible());
	// aufraeumen .. 
	$('vspFormError').remove();
	util.removeHtmlTmp();
	util.log('test_setclearErrorInDom = ok');
  },
  test_checkIfFormValid: function() {
	fec.form.initFormValidation();
	this.mockupEffects();
	// Fehler hinzufuegen
	util.addHtmlTmp(util.htmlForm);
  	fec.form.setErrorInDom($(fec.util.eleId('Param1')),"Param1-Fehler");
	// ist Form valide? Nein ..
	this.assertFalse(fec.form.checkIfFormValid());
	this.assertTrue($('vspFormError').visible());
	// Fehler loeschen
	fec.form.clearErrorsInDom();
	// ist Form valide? Ja .. 
	this.assertTrue(fec.form.checkIfFormValid());
	this.assertFalse($('vspFormError').visible());
	// aufraeumen
	this.undoEffectsMockup();
	util.removeHtmlTmp();
	util.log('test_checkIfFormValid = ok');
  },
  test_checkRegex: function() {
	this.assertTrue(fec.form.checkTypeNumber('200'));
	this.assertFalse(fec.form.checkTypeNumber('two'));
	this.assertFalse(fec.form.checkTypeNumber('200two'));
	this.assertFalse(fec.form.checkTypeNumber('two200'));
	this.assertTrue(fec.form.checkTypeDate('01.01.2002'));
	this.assertFalse(fec.form.checkTypeDate('31.31.9999'));
	this.assertFalse(fec.form.checkTypeDate('29.02.1993'));
	this.assertFalse(fec.form.checkTypeDate('01.01.06'));
	this.assertFalse(fec.form.checkTypeDate('01/01/2006'));
	this.assertFalse(fec.form.checkTypeDateInPast('01.01.2099'));
	this.assertTrue(fec.form.checkTypeDateInPast('01.01.2008'));
	this.assertFalse(fec.form.checkTypeDateInPast('32.13.1234'));
	// Email
	this.assertTrue(fec.form.checkTypeEmail('a@b.c'));
	this.assertTrue(fec.form.checkTypeEmail('test@subdomain.example.com'));
	this.assertFalse(fec.form.checkTypeEmail('a'));
	this.assertFalse(fec.form.checkTypeEmail('a@b'));
	this.assertFalse(fec.form.checkTypeEmail('a.b'));
	// Bankleitzahl darf nicht mit einer Null anfangen und muss genau acht Stellen haben
	this.assertTrue(fec.form.checkRegex(/^[1-9]{1}[0-9]{7}$/,'20041234'));
	this.assertFalse(fec.form.checkRegex(/^[1-9]{1}[0-9]{7}$/,'02004123'));
	this.assertFalse(fec.form.checkRegex(/^[1-9]{1}[0-9]{7}$/,'123456789'));
	// Postleitzahl
	this.assertFalse(fec.form.checkTypePostleitzahl('1abcd'));
	this.assertFalse(fec.form.checkTypePostleitzahl('@!.-'));
	this.assertFalse(fec.form.checkTypePostleitzahl('123'));
	this.assertFalse(fec.form.checkTypePostleitzahl('1234567'));
	this.assertFalse(fec.form.checkTypePostleitzahl('123a1'));
	this.assertTrue(fec.form.checkTypePostleitzahl('00231'));
	this.assertTrue(fec.form.checkTypePostleitzahl('12345'));
	this.assertTrue(fec.form.checkTypePostleitzahl('01234'));
	this.assertTrue(fec.form.checkTypePostleitzahl('54321'));
	// Hausnnummer mit Zusatz
	this.assertFalse(fec.form.checkTypeHausnummerMitZusatz('abcd'));
	this.assertFalse(fec.form.checkTypeHausnummerMitZusatz('@123'));
	this.assertFalse(fec.form.checkTypeHausnummerMitZusatz('a12-13b'));
	this.assertFalse(fec.form.checkTypeHausnummerMitZusatz('01a-14c'));
	this.assertTrue(fec.form.checkTypeHausnummerMitZusatz('1'));
	this.assertTrue(fec.form.checkTypeHausnummerMitZusatz('12-14'));
	this.assertTrue(fec.form.checkTypeHausnummerMitZusatz('12a'));
	this.assertTrue(fec.form.checkTypeHausnummerMitZusatz('12 Ecke Baumgartenstrasse'));
	util.log('test_checkRegex = ok');
  },
  test_setElementReadonly: function() {
	util.addHtmlTmp(util.htmlForm);
	fec.form.setElementReadonly($(fec.util.eleId('Param1')), true);
	this.assertTrue($(fec.util.eleId('Param1')).readOnly === true);
	this.assertTrue($(fec.util.eleId('Param1')).value == '');
	fec.form.setElementReadonly($(fec.util.eleId('Param1')), false);
	this.assertTrue($(fec.util.eleId('Param1')).readOnly === false);
	this.assertTrue($(fec.util.eleId('Param1')).style.backgroundColor === '');
	util.removeHtmlTmp();
	util.log('test_setElementReadonly = ok');
  },
  test_checkTypeString: function() {
	util.addHtmlTmp(util.htmlForm);
	this.mockUp(fec.form, 'setErrorInDom', function(input, err) { util.log('test_test_checkTypeString = ok - ele_id: ' + input.id + ' err: ' + err );return; });
	
	// ok  faelle
	fec.form.checkTypeString($('dummy'), true, 2, 5, "Der DataParam1");
	$(fec.util.eleId('Param1')).value ="123";
	fec.form.checkTypeString($(fec.util.eleId('Param1')), true, 2, 5, "Der DataParam1");
	fec.form.checkTypeString($(fec.util.eleId('Param1')), false, 2, null, "Der DataParam1");
	fec.form.checkTypeString($(fec.util.eleId('Param1')), true, null, 3, "Der DataParam1");
	fec.form.checkTypeString($(fec.util.eleId('Param1')), true, null, null, "Der DataParam1");
	this.assertFalse(util.findHtml('Der DataParam1.'));
	// Pflichtfeld 
	$(fec.util.eleId('Param1')).value ="";
	fec.form.checkTypeString($(fec.util.eleId('Param1')), false, 2, 5, "Der DataParam1");
	this.assertFalse(util.findHtml('Der DataParam1 ist ein Pflichtfeld.'));
	fec.form.checkTypeString($(fec.util.eleId('Param1')), true, 2, 5, "Der DataParam1");
	this.assertTrue(util.findHtml('Der DataParam1 ist ein Pflichtfeld.'));
	// laenge
	$(fec.util.eleId('Param1')).value ="123";
	fec.form.checkTypeString($(fec.util.eleId('Param1')), false, 4, null, "Der DataParam1");
	this.assertTrue(util.findHtml('Der DataParam1 muss mindestens 4 Zeichen lang sein.'));
	$(fec.util.eleId('Param1')).value ="123456";
	fec.form.checkTypeString($(fec.util.eleId('Param1')), true, null, 5, "Der DataParam1");
	this.assertTrue(util.findHtml('Der DataParam1 darf maximal 5 Zeichen lang sein.'));
	fec.form.checkTypeString($(fec.util.eleId('Param1')), true, 2, 5, "Der DataParam1");
	this.assertTrue(util.findHtml('Der DataParam1 muss zwischen 2 und 5 Zeichen lang sein.'));
	$(fec.util.eleId('Param1')).value ="1";
	fec.form.checkTypeString($(fec.util.eleId('Param1')), true, 3, 6, "Der DataParam1");
	this.assertTrue(util.findHtml('Der DataParam1 muss zwischen 3 und 6 Zeichen lang sein.'));

	util.removeHtmlTmp();
	this.undoMockup(fec.form, 'setErrorInDom');  	
	util.log('test_checkTypeString = ok');
	},
	test_finally: function() {
		util.cleanLog();
	}
});

/* ___________ Test fec.cookies Klasse aus fec.js ______________ */
TestCaseUtil.FecCookies = TestCase.create({
  name: "TestCaseUtil.FecCookies",
  test_set_get_erase: function() {
	// setzen, auslesen, loeschen
	fec.cookies.set('jsunit','tempval',24);
	this.assertEqual(fec.cookies.get('jsunit'),'tempval');
	fec.cookies.erase('jsunit');
	this.assertEqual(fec.cookies.get('jsunit'),undefined);
	this.assertEqual(fec.cookies.get('jsunit','defaultvalue'),'defaultvalue');
	// setzen einfach
	fec.cookies.set('portalid','sl',24);
	this.assertEqual(fec.cookies.get('portalid'),'sl');
	fec.cookies.erase('portalid');
	// setzen komplex
	fec.cookies.set('vspr',util.cookieDefault,24);
	this.assertEqual(fec.cookies.get('vspr'),util.cookieDefault);
	fec.cookies.erase('vspr');
	// setzen Sonderzeichen
	var key = 'sonderzeichen';
	var value = '!"§$%&/=?';
	fec.cookies.set(key,value,24);
	this.assertEqual(fec.cookies.get(key), value);
	fec.cookies.erase(key);
	util.log('test_set_get_erase = ok');
  }
});

/* ___________ Test fec.util Klasse aus fec.js ______________ */
TestCaseUtil.FecUtil = TestCase.create({
  name: "TestCaseUtil.FecUtil",
  
  test_addLoadEvent: function() {
	fec.util.addLoadEvent(function(){util.log('test_addLoadEvent = ok');});
	//this.assertTrue(util.findLog('addLoadEvent')); geht nicht weil zu frueh
  },
  test_submitObserver: function() {
	// Todo im IE will der Test nicht klappen
	if(!Prototype.Browser.IE) {
		util.addHtmlTmp('<form action="#" id="'+fec.config.htmlIdForm+'"><input type=submit id="tmpsubmit" /></form>');
		fec.util.submitObserver($(fec.config.htmlIdForm));
		this.mockUp(fec.base, 'dataSend', function() { util.log('test_submitObserver = ok'); });	
		var event = this.fireClick('tmpsubmit');
		this.assertTrue(util.findLog('submitObserver'));
		util.removeHtmlTmp();
		this.undoMockup(fec.base, 'dataSend');
	}  	
  },  
  test_submitWithGotoPage: function() {
	fec.main = new FecMain();
	fec.pageControl = new FecPageControl(util.pcMin);
	this.mockUp(fec.base, 'dataSend', function() { util.log('test_submitWithGotoPage = ok'); });	
	this.mockUp(fec.util, 'redirect', function() { util.log('test_submitWithGotoPage = ok'); });	
	fec.util.submitWithGotoPage('jsunit'); 
	this.assertTrue(util.findLog('submitWithGotoPage'));
	this.assertEqual(fec.pageControl.getGotoPage(),'jsunit');
	this.assertEqual(fec.pageControl.getParameter().get('validate'),false);
	this.undoMockup(fec.base, 'dataSend');
	this.undoMockup(fec.util, 'redirect');
	fec.pageControl = undefined;
  	fec.main = undefined;
  },
  test_submitWithAction: function() {
	fec.main = new FecMain();
	fec.pageControl = new FecPageControl(util.pcMin);
	this.mockUp(fec.base, 'dataSend', function() { util.log('test_submitWithAction = ok'); });	
	fec.util.submitWithAction('jsunit'); 
	this.assertTrue(util.findLog('submitWithAction'));
	this.assertEqual(['jsunit'], fec.pageControl.getControl('paramsSend'));
	this.assertEqual(false, fec.pageControl.getParameter().get('validate'));
	this.undoMockup(fec.base, 'dataSend');
	fec.pageControl = undefined;
  	fec.main = undefined;
  },  
  test_chkUndef: function() {
	this.assert_equal(fec.util.chkUndef('test'), 'test');
	this.assert_equal(fec.util.chkUndef(undefined), '');
	this.assert_equal(fec.util.chkUndef(null), '');
	this.assert_equal(fec.util.chkUndef('test','suffix'), 'testsuffix');
	this.assert_equal(fec.util.chkUndef(undefined,'suffix'), 'suffix');
	util.log('test_chkUndef = ok');
  },
  test_getQueryParams: function() {
	var q = fec.util.getQueryParams();
	// Wenn keine Params angegeben wurden, dann size = 0
	this.assertTrue(q.size() === 0);
	util.log('test_getQueryParams = ok');
  },  
  test_popup: function() {
	// Test macht probleme wegen popup blocker etc 
	//var win = fec.util.popup(10,10,'http://www.this-page-intentionally-left-blank.org/','Google',true);
	//win.close();
	//util.log('test_popup = ok');
  },
  test_getImageRoot: function() {
	this.assertTrue(fec.util.getImageRoot().endsWith('/'));
	// Fuege defautimage hinzu, da im HTML am Ende und noch nicht sichtbar
	$$('body')[0].insert({'top':'<img src="fileadmin/VOS/images/48x48/info.gif" alt="default" id="defaultImage" style="display:none" />'});   
	this.assertTrue(fec.util.getImageRoot().search(location.host+'/') > 0);
	// mit URL Angabe .. darf aber nur ein / ergeben
	var u = fec.util.getImageRoot('/index.html');
	this.assertTrue(u.search('\/index.html') > 0);
	this.assertFalse(u.search('\/\/index.html') > 0);
	u = fec.util.getImageRoot('jsunit/index.html');
	this.assertTrue(u.search('\/jsunit\/index.html') > 0);
	this.assertFalse(u.search('\/\/jsunit\/index.html') > 0);
	$('defaultImage').remove();
	util.log('test_getImageRoot = ok');
  },
  test_formatMessage: function() {
  	this.assertEqual(fec.util.formatMessage("Ein ##TEST##!", {'TEST':'test'}), "Ein test!");
  	this.assertEqual(fec.util.formatMessage("Ein ##TEST##, noch ein ##TEST##!", {'TEST':'test'}), "Ein test, noch ein test!");
  	this.assertEqual(fec.util.formatMessage("##EINS## ##ZWEI## ##DREI##", {'EINS':'1','ZWEI':'2','DREI':'3'}), "1 2 3");
	util.log('test_formatMessage = ok');
  },
  test_getPageAddressRoot: function() {
	this.assertTrue(fec.util.getPageAddressRoot().endsWith('/'));
	// mit URL Angabe .. darf aber nur ein / ergeben
	var u = fec.util.getPageAddressRoot('/index.html');
	this.assertTrue(u.search('\/index.html') > 0);
	u = fec.util.getPageAddressRoot('jsunit/index.html');
	this.assertTrue(u.search('\/jsunit\/index.html') > 0);
	util.log('test_getPageAddressRoot = ok');
  }, 
  test_getErrorPage: function() {
	var e = fec.util.getErrorPage();
	this.assertNotMatch('errid', e);
	e = fec.util.getErrorPage('jsunit');
	this.assertMatch('errid=jsunit', e);
	// Helios Teil kann man nicht testen, da window.location.href nicht geändert werden kann
	util.log('test_getErrorPage = ok');
  },   
  test_misc: function() {
	//lexus_test.html ist nicht im Frame --> false
	this.assert_equal(fec.util.escapeFrame(), false);
	// ausfuehrung reicht
	fec.util.alertTime('fec.util - test_alertTime');
	util.log('test_misc = ok');
	
	// ganz am Ende ausfuehren
	window.scrollTo(0,0);
  },
  test_capitalizeByChar: function() {
	this.assertEqual('/Services/Test/Jsunit.html',fec.util.capitalizeByChar('/services/test/jsunit.html','/'));
	this.assertEqual('\\services/Test\\jsunit.html',fec.util.capitalizeByChar('\\services/test\\jsunit.html','/'));
	util.log('test_capitalizeByChar = ok');
  },
  test_setDatumsfelder: function() {
	util.addHtmlTmp(util.htmlForm);
	$(fec.config.htmlIdForm).insert({'bottom':'<select id="'+fec.util.eleId('Geburtstag')+'" name="'+fec.util.eleId('Geburtstag')+'" size="1"><option value="" selected="selected">Tag</option></select><select id="'+fec.util.eleId('Geburtsmonat')+'" name="'+fec.util.eleId('Geburtsmonat')+'" size="1"><option value="" selected="selected">Monat</option></select><select id="'+fec.util.eleId('Geburtsjahr')+'" name="'+fec.util.eleId('Geburtsjahr')+'" size="1"><option value="" selected="selected">Jahr</option></select>'});		
	// Fuelle Felder ohne Datum
	fec.util.setDatumsfelder($(fec.util.eleId('Geburtstag')), $(fec.util.eleId('Geburtsmonat')), $(fec.util.eleId('Geburtsjahr')));
	this.assertEqual(32, $(fec.util.eleId('Geburtstag')).options.length);
	this.assertEqual(13, $(fec.util.eleId('Geburtsmonat')).options.length);
	this.assertTrue($(fec.util.eleId('Geburtsjahr')).options.length > 110); // das Jahr variiert mit jedem neuen Jahr , deswegen größer Vergleich
	this.assertEqual(0, $(fec.util.eleId('Geburtstag')).selectedIndex);
	this.assertEqual(0, $(fec.util.eleId('Geburtsmonat')).selectedIndex);
	this.assertEqual(0, $(fec.util.eleId('Geburtsjahr')).selectedIndex);
	// Datum update mit vorhandenen Feldern
	fec.util.setDatumsfelder($(fec.util.eleId('Geburtstag')), $(fec.util.eleId('Geburtsmonat')), $(fec.util.eleId('Geburtsjahr')), '12.12.1912');
	this.assertEqual(12, $(fec.util.eleId('Geburtstag')).selectedIndex);
	this.assertEqual(12, $(fec.util.eleId('Geburtsmonat')).selectedIndex);
	this.assertTrue($(fec.util.eleId('Geburtsjahr')).selectedIndex > 97);
	// Datum updaten ohne Felder 
	util.removeHtmlTmp();
	util.addHtmlTmp(util.htmlForm);
	$(fec.config.htmlIdForm).insert({'bottom':'<select id="'+fec.util.eleId('Geburtstag')+'" name="'+fec.util.eleId('Geburtstag')+'" size="1"><option value="" selected="selected">Tag</option></select><select id="'+fec.util.eleId('Geburtsmonat')+'" name="'+fec.util.eleId('Geburtsmonat')+'" size="1"><option value="" selected="selected">Monat</option></select><select id="'+fec.util.eleId('Geburtsjahr')+'" name="'+fec.util.eleId('Geburtsjahr')+'" size="1"><option value="" selected="selected">Jahr</option></select>'});		
	fec.util.setDatumsfelder($(fec.util.eleId('Geburtstag')), $(fec.util.eleId('Geburtsmonat')), $(fec.util.eleId('Geburtsjahr')), '12.12.1912');
	this.assertEqual(12, $(fec.util.eleId('Geburtstag')).selectedIndex);
	this.assertEqual(12, $(fec.util.eleId('Geburtsmonat')).selectedIndex);
	this.assertTrue($(fec.util.eleId('Geburtsjahr')).selectedIndex > 97);
	
	util.removeHtmlTmp();	
	util.log('test_setDatumsfelder = ok');
  },
  test_isCompleted: function() {
  	// Default false
	fec.main = undefined;
	this.assertFalse(fec.util.isCompleted());
	// true
	fec.main = new FecMain();
	var rStr = Object.toJSON(util.responseMin);
	fec.main.processResponse('load', rStr);
	this.assertTrue(fec.util.isCompleted());
	util.log('test_isCompleted = ok');
  },
  test_addParamToUrl: function() {
  	// params anhaengen
	var url = 'http://localhost:8080';
  	url = fec.util.addParamToUrl(url, 'param1', 'value1');
	this.assertTrue(url === 'http://localhost:8080?param1=value1');
  	url = fec.util.addParamToUrl(url, 'param2', 'value2');
	this.assertTrue(url === 'http://localhost:8080?param1=value1&param2=value2');
	// mit Pfadangabe
	url = 'http://localhost:8080/path1/path2/';
  	url = fec.util.addParamToUrl(url, 'param1', 'value1');
	// evtl letztes / ini Funktion entfernen
	this.assertTrue(url === 'http://localhost:8080/path1/path2/?param1=value1');
	url = 'http://localhost:8080/path1/path2/';
	// urlencode
	var url = 'http://localhost:8080';
  	url = fec.util.addParamToUrl(url, 'param1', '?= /');
	this.assertTrue(url === 'http://localhost:8080?param1=%3F%3D%20%2F');
  },  
  test_replaceAllCss: function() {
  	util.removeHtmlTmp();
	util.addHtmlTmp('<div class="huge naked box" id="'+fec.config.htmlIdLoaderPrefix+'Dienstuebersicht"><div class="ladebalken-error"/></div>');
	// Beispiel ladebalken
	fec.util.replaceAllCss('ladebalken-error','ladebalken-new');
	this.assertTrue(util.findHtml('ladebalken-new', $('tmp')));
	this.assertFalse(util.findHtml('ladebalken-error', $('tmp')));
	// mehrere CSS Angaben vorhanden
	fec.util.replaceAllCss('naked','cssnew');
	this.assertTrue(util.findHtml('cssnew', $('tmp')));
	this.assertFalse(util.findHtml('naked', $('tmp')));
	
	util.log('test_replaceAllCss = ok');
  },   
  test_finally: function() {
	util.cleanLog();
  }
});

/* ------------------------------------------------------- */
var build_test_suite = new TestSuite(
	TestCaseUtil.Fec,
	TestCaseUtil.FecMain,
	TestCaseUtil.SetValues,
	TestCaseUtil.FecPageControl,
	TestCaseUtil.FecCookies,
	TestCaseUtil.FecForm,
	TestCaseUtil.FecUtil
);
