﻿<%@ WebHandler Language="C#" Class="DownloadHandler" %>

using System;
using System.Web;

public class DownloadHandler : IHttpHandler
{
    public void ProcessRequest(HttpContext context)
    {
        if (!context.User.IsInRole("Benutzer"))
        {
            context.Response.Write("<html>Sie haben keinen Zugang zu diesen Dateien, wenn Sie nicht angemeldet sind!</html>");
            context.Response.End();
            return;
        }

        long Anz = Convert.ToInt64(context.Profile.GetPropertyValue("AnzahlDownloads")) + 1;
         context.Profile.SetPropertyValue("AnzahlDownloads", ((object)Anz) );
        string Dateiname = context.Request.QueryString["Datei"];
        // Zusammenstellen des Pfades
        string Pfad = context.Server.MapPath("App_Data/Dateien/" + Dateiname);
        // Ermitteln der Länge
        System.IO.FileInfo file = new System.IO.FileInfo(Pfad);
        // Setzen der Header-Daten
        context.Response.ContentType = "binary/octet-stream";
        context.Response.AddHeader("Content-Type", "binary/octet-stream");
        context.Response.AddHeader("Content-Length", file.Length.ToString());
        context.Response.AddHeader("Content-Disposition", "attachment; filename=" + Dateiname + "; size=" + file.Length.ToString());
        // Schreiben der Datei
        context.Response.WriteFile(Pfad);
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
}