﻿using System;
using System.Linq;
using Microsoft.Samples.ServiceHosting.StorageClient;

namespace ReminderService_WebRole
{
    public class Termin : TableStorageEntity
    {
        public String Beschreibung { get; set; }
        public DateTime Date { get; set; }
        public String Ort { get; set; }

        public void setKeys()
        {
            //PseudoHash aus Terminwerten  für RowKey erstellen
            PartitionKey = "gemeinsameTermine";
            RowKey = String.Format("{0:MMddyyyy}", Date);
            RowKey += Ort.Length <= 15 ? Ort : Ort.Substring(0, 15);
            RowKey += Beschreibung.Length <= 15 ?
                        Beschreibung : Beschreibung.Substring(0, 15);
        }
    }
    public class TerminContext : TableStorageDataServiceContext
    {
        public TerminContext(StorageAccountInfo info)
            : base(info) { }
        public IQueryable<Termin> Termin
        {
            get
            {
                return this.CreateQuery<Termin>("Termin");
            }
        }
    }

}