import de.ix.mk.Part;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;

import javafx.ext.swing.SwingTextField;
import javafx.ext.swing.SwingLabel;
import javafx.scene.Scene;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

var fileName = FX.getArguments()[0];

var part: Part = Part.load(fileName);

var textFieldId = SwingTextField {
	width: 250
	text: part.id;
};

var textFieldShortDescription = SwingTextField {
	width: 250
	text: part.shortDescription;
};

var textFieldLongDescription = SwingTextField {
	width: 250
	text: part.longDescription;
};

Stage {
	title: "{fileName} - Part"
	scene: Scene {
		height: 100
		content: [
			VBox {
				content: [
					SwingLabel {
						text: "Edit part here, then close window to save."
					}
					textFieldId
					textFieldShortDescription
					textFieldLongDescription
				]
			}
		]
	}
	onClose: function() {
		part.id = textFieldId.text;
		part.shortDescription = textFieldShortDescription.text;
		part.longDescription = textFieldLongDescription.text;
		Part.save(part, fileName);
	}
}