package de.ix.mk;

import java.io.File;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public final class Part {

	public static final Part load(final String fileName) throws Exception {
		final JAXBContext context = JAXBContext.newInstance(Part.class);
		return (Part) context.createUnmarshaller().unmarshal(new File(fileName));
	}

	public static final void save(final Part part, final String fileName) throws Exception {
		final JAXBContext context = JAXBContext.newInstance(Part.class);
		context.createMarshaller().marshal(part, new File(fileName));
	}

	public String id;

	public String shortDescription;

	public String longDescription;

	protected Part() {
		// Needed for JAXB only.
	}

	public Part(final String id, final String shortDescription, final String longDescription) {
		this.id = id;
		this.shortDescription = shortDescription;
		this.longDescription = longDescription;
	}

}
