package de.ix.mk;

import static javax.ws.rs.core.HttpHeaders.CONTENT_LENGTH;
import static javax.ws.rs.core.Response.Status.OK;
import static net.java.dev.webdav.core.jaxrs.Headers.DAV;
import static net.java.dev.webdav.core.jaxrs.Headers.DEPTH;
import static net.java.dev.webdav.core.jaxrs.Headers.DEPTH_0;
import static net.java.dev.webdav.core.jaxrs.Headers.DEPTH_INFINITY;
import static net.java.dev.webdav.core.jaxrs.Headers.DESTINATION;
import static net.java.dev.webdav.core.jaxrs.Headers.OVERWRITE;
import static net.java.dev.webdav.core.jaxrs.xml.properties.ResourceType.COLLECTION;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;

import net.java.dev.webdav.core.jaxrs.methods.COPY;
import net.java.dev.webdav.core.jaxrs.methods.MOVE;
import net.java.dev.webdav.core.jaxrs.methods.OPTIONS;
import net.java.dev.webdav.core.jaxrs.methods.PROPFIND;
import net.java.dev.webdav.core.jaxrs.methods.PROPPATCH;
import net.java.dev.webdav.core.jaxrs.xml.elements.HRef;
import net.java.dev.webdav.core.jaxrs.xml.elements.MultiStatus;
import net.java.dev.webdav.core.jaxrs.xml.elements.Prop;
import net.java.dev.webdav.core.jaxrs.xml.elements.PropStat;
import net.java.dev.webdav.core.jaxrs.xml.elements.Response;
import net.java.dev.webdav.core.jaxrs.xml.elements.Status;
import net.java.dev.webdav.core.jaxrs.xml.properties.CreationDate;
import net.java.dev.webdav.core.jaxrs.xml.properties.DisplayName;
import net.java.dev.webdav.core.jaxrs.xml.properties.GetContentLength;
import net.java.dev.webdav.core.jaxrs.xml.properties.GetContentType;
import net.java.dev.webdav.core.jaxrs.xml.properties.GetLastModified;

@Path("parts")
public final class WrapperResource {

	private static final String PART_MIME = "application/part+xml";

	@OPTIONS
	public final javax.ws.rs.core.Response options() {
		return javax.ws.rs.core.Response.noContent().header(DAV, "1").build();
	}

	@SuppressWarnings("unchecked")
	@PROPFIND
	public final MultiStatus propfind(@Context final UriInfo uriInfo, @DefaultValue(DEPTH_INFINITY) @HeaderParam(DEPTH) final String depth) {
		final Response folder = new Response(new HRef(uriInfo.getRequestUri()), null, null, null, new PropStat(new Prop(new MicrosoftRedirectorPatch2(),
				new DisplayName("My Collection"), new CreationDate(new Date()), new GetLastModified(new Date()), COLLECTION), new Status(OK)));

		if (depth.equals(DEPTH_0))
			return new MultiStatus(folder);

		/* Instead, use native API to read list of parts from backend. */

		final Collection<Response> responses = new LinkedList<Response>(Collections.singletonList(folder));
		responses.add(new Response(new HRef(uriInfo.getAbsolutePathBuilder().path("4711.part").build()), null, null, null, new PropStat(new Prop(
				new MicrosoftRedirectorPatch2(), new DisplayName("Part 4711"), new CreationDate(new Date()), new GetLastModified(new Date()),
				new GetContentLength(0), new GetContentType(PART_MIME)), new Status(OK))));

		return new MultiStatus(responses.toArray(new Response[0]));
	}

	@PROPFIND
	@Path("{filename}.part")
	public final MultiStatus propfind(@PathParam("filename") final String matchCode, @Context final UriInfo uriInfo) {
		/* Instead, use native API to read part from backend. */

		return new MultiStatus(new Response(new HRef(uriInfo.getAbsolutePathBuilder().build()), null, null, null, new PropStat(new Prop(
				new MicrosoftRedirectorPatch2(), new DisplayName("Part 4711"), new CreationDate(new Date()), new GetLastModified(new Date()),
				new GetContentLength(0), new GetContentType(PART_MIME)), new Status(OK))));
	}

	@PROPPATCH
	@Path("{filename}.part")
	public final void proppatch(final InputStream body, @Context final Providers providers, @Context final HttpHeaders httpHeaders) throws IOException {
		// Not supported in this sample.
	}

	@GET
	@Produces(PART_MIME)
	@Path("{filename}.part")
	public final Part get(@PathParam("filename") final String matchCode) {
		/* Instead, use native API to read part from backend. */
		return new Part("4711", "Part 4711", "This is a sample part.");
	}

	@PUT
	@Consumes(PART_MIME)
	@Path("{filename}.part")
	public final void put(final InputStream entityStream, @PathParam("filename") final String matchCode, @HeaderParam(CONTENT_LENGTH) final long contentLength,
			@Context final Providers providers, @Context final HttpHeaders httpHeaders) throws IOException {
		/* Instead, use native API to write part into backend. */
	}

	@DELETE
	@Path("{filename}.part")
	public final void delete(@PathParam("filename") final String matchCode) {
		/* Instead, use native API to delete part from backend. */
	}

	@MOVE
	@Path("{filename}.part")
	public final void move(@PathParam("filename") final String sourceMatchCode, @HeaderParam(DESTINATION) final URI destination,
			@HeaderParam(OVERWRITE) final String overwrite) {
		/* Instead, use native API to move part inside of backend. */
	}

	@COPY
	@Path("{filename}.part")
	public final void copy(@PathParam("filename") final String sourceMatchCode, @HeaderParam(DESTINATION) final URI destination,
			@HeaderParam(OVERWRITE) final String overwrite) {
		/* Instead, use native API to copy part inside of backend. */
	}

}
