package de.ix.mk;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

import javax.ws.rs.core.Application;
import javax.xml.bind.JAXBException;

import net.java.dev.webdav.core.jaxrs.xml.WebDavContextResolver;

public final class WrapperApplication extends Application {

	@SuppressWarnings("unchecked")
	@Override
	public final Set<Class<?>> getClasses() {
		return new HashSet<Class<?>>(Arrays.asList(WrapperResource.class, MicrosoftRedirectorPatch1.class));
	}

	@Override
	public Set<Object> getSingletons() {
		try {
			return new HashSet<Object>(Arrays.asList(new WebDavContextResolver(MicrosoftRedirectorPatch2.class, Win32LastAccessTime.class)));
		} catch (final JAXBException e) {
			Logger.getLogger(WrapperApplication.class.getName()).severe(e.toString());
			return null;
		}
	}

}
