//
//  AddToDoItemViewController.m
//  MyDo
//
//  Created by Markus Stäuble on 11.09.09.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "AddToDoItemViewController.h"
#import "ToDoItem.h"
#import "MyDoAppDelegate.h"


@implementation AddToDoItemViewController

@synthesize longDescriptionField, todoNameField, dateLabel, dateFormatter, priorityField, pickerView, todoItem;

// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
	self.title = @"Neues ToDo";
	
	self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] 
											  initWithBarButtonSystemItem:UIBarButtonSystemItemCancel 
											  target:self action:@selector(cancel_Clicked:)] autorelease];
	
	self.navigationItem.rightBarButtonItem = [[[UIBarButtonItem alloc] 
											   initWithBarButtonSystemItem:UIBarButtonSystemItemSave 
											   target:self action:@selector(save_Clicked:)] autorelease];
	
	self.dateFormatter = [[[NSDateFormatter alloc] init] autorelease];
	[self.dateFormatter setDateStyle:NSDateFormatterShortStyle];
	
	self.longDescriptionField.delegate=self;
	self.todoNameField.delegate=self;
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
	if (todoItem == nil) {
		self.dateLabel.titleLabel.text = [self.dateFormatter stringFromDate:[NSDate date]];
		self.todoNameField.text=nil;
		self.longDescriptionField.text=nil;
	} else {
		todoNameField.text = todoItem.shortDesc;
		priorityField.selectedSegmentIndex = [todoItem.priority intValue]-1;
		dateLabel.titleLabel.text = [self.dateFormatter stringFromDate:todoItem.until];
		longDescriptionField.text = todoItem.longDesc;
	}
}

- (void) save_Clicked:(id)sender {
	MyDoAppDelegate *appDelegate = (MyDoAppDelegate *)[[UIApplication sharedApplication] delegate];
	
	if (todoItem == nil) {
		//Erzeugung neues ManagedObject
		todoItem = (ToDoItem *)[NSEntityDescription insertNewObjectForEntityForName:@"ToDoItem" inManagedObjectContext:appDelegate.managedObjectContext];
	}
	
	//Werte uebertragen
	
	todoItem.shortDesc = todoNameField.text;
	todoItem.priority = [NSNumber numberWithInt:priorityField.selectedSegmentIndex+1];
	todoItem.until = [self.dateFormatter dateFromString:dateLabel.titleLabel.text];
	todoItem.longDesc = longDescriptionField.text;
	
	
	NSError *error;	
	if (![appDelegate.managedObjectContext save:&error]) {
		NSLog(@"Fehler beim Speichern der Aufgabe");
	}
	
	[self.navigationController dismissModalViewControllerAnimated:YES];
	todoItem = nil;
}	

- (void) cancel_Clicked:(id)sender {
	todoItem = nil;
	[self.navigationController dismissModalViewControllerAnimated:YES];	
}


/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
	[dateFormatter dealloc];
}

#pragma mark -
#pragma mark Date selection

//Anzeige der Datumsauswahl
- (IBAction)showDatePicker:(id)sender
{
	
	[self.view.window addSubview: self.pickerView];
	
	CGRect screenRect = [[UIScreen mainScreen] applicationFrame];
	CGSize pickerSize = [self.pickerView sizeThatFits:CGSizeZero];
	CGRect startRect = CGRectMake(0.0,
								  screenRect.origin.y + screenRect.size.height,
								  pickerSize.width, pickerSize.height);
	self.pickerView.frame = startRect;
	
	CGRect pickerRect = CGRectMake(0.0,
								   screenRect.origin.y + screenRect.size.height - pickerSize.height,
								   pickerSize.width,
								   pickerSize.height);

	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:0.3];
	
	[UIView setAnimationDelegate:self];
	
	self.pickerView.frame = pickerRect;
	
	CGRect newFrame = self.view.frame;
	newFrame.size.height -= self.pickerView.frame.size.height;
	self.view.frame = newFrame;
	[UIView commitAnimations];
	
	//Buttons aendern
	
	self.navigationItem.rightBarButtonItem = [[[UIBarButtonItem alloc] 
											   initWithBarButtonSystemItem:UIBarButtonSystemItemDone 
											   target:self action:@selector(save_date:)] autorelease];
	self.navigationItem.leftBarButtonItem = nil;
}

//Datum speichern und Datumsauswahl ausblenden
- (void) save_date:(id)sender {
	self.dateLabel.titleLabel.text = [self.dateFormatter stringFromDate:self.pickerView.date];	
	
	CGRect screenRect = [[UIScreen mainScreen] applicationFrame];
	CGRect endFrame = self.pickerView.frame;
	endFrame.origin.y = screenRect.origin.y + screenRect.size.height;
	

	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:0.3];
	
	[UIView setAnimationDelegate:self];
	[UIView setAnimationDidStopSelector:@selector(slideDownDidStop)];
	
	self.pickerView.frame = endFrame;
	[UIView commitAnimations];
	
	CGRect newFrame = self.view.frame;
	newFrame.size.height += self.pickerView.frame.size.height;
	self.view.frame = newFrame;

	
	// Urspruengliche Buttons wieder anzeigen
	
	self.navigationItem.rightBarButtonItem =  [[[UIBarButtonItem alloc] 
												initWithBarButtonSystemItem:UIBarButtonSystemItemSave 
												target:self action:@selector(save_Clicked:)] autorelease];
	
	self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] 
											  initWithBarButtonSystemItem:UIBarButtonSystemItemCancel 
											  target:self action:@selector(cancel_Clicked:)] autorelease];
	
}

#pragma mark -
#pragma mark UITextViewDelegate

/**
 * Ueber die RETURN-Taste wird die Tastatur beim UITextView ausgeblendet.
 */
-(BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text
{	
	if([text isEqualToString:@"\n"])		
	{
		[textView resignFirstResponder];		
		return NO;
	}
	return YES; 
}

#pragma mark -
#pragma mark UITextFieldDelegate
- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
	[textField resignFirstResponder];
	return YES;
}


@end
