//
//  RootViewController.h
//  MyDo
//
//  Created by Markus Stäuble on 19.08.09.
//  Copyright __MyCompanyName__ 2009. All rights reserved.
//

@class AddToDoItemViewController, ToDoItemCell;

@interface RootViewController : UITableViewController <NSFetchedResultsControllerDelegate> {
	NSFetchedResultsController *fetchedResultsController;
	NSManagedObjectContext *managedObjectContext;
	
	AddToDoItemViewController* addController;
	UINavigationController *addNavigationController;
	
	IBOutlet ToDoItemCell *cell;
	NSMutableArray *todoItemsArray;
	NSDateFormatter *dateFormatter;
	IBOutlet UIToolbar *toolbar;
	
@private
	Boolean priorityAscending;
	Boolean dateAscending;
	Boolean nameAscending;
}

@property (nonatomic, retain) NSFetchedResultsController *fetchedResultsController;
@property (nonatomic, retain) NSManagedObjectContext *managedObjectContext;
@property (nonatomic, retain) NSMutableArray *todoItemsArray;
@property (nonatomic, retain) NSDateFormatter *dateFormatter; 

- (IBAction)sortByDate:(id)sender;
- (IBAction)sortByPriority:(id)sender;
- (IBAction)sortByShortDesc:(id)sender;
- (IBAction)delete_Clicked:(id)sender;

- (void) sortTableView:(NSString*)descriptor ascending:(Boolean)ascending;

@end
