//
//  RootViewController.m
//  MyDo
//
//  Created by Markus Stäuble on 19.08.09.
//  Copyright __MyCompanyName__ 2009. All rights reserved.
//

#import "RootViewController.h"
#import "AddToDoItemViewController.h"
#import "ToDoItem.h"
#import "ToDoItemCell.h"


@implementation RootViewController

@synthesize fetchedResultsController, managedObjectContext, todoItemsArray, dateFormatter;


- (void)viewDidLoad {
    [super viewDidLoad];

	// Set up the edit and add buttons.
    self.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc] 
											 initWithBarButtonSystemItem:UIBarButtonSystemItemEdit
											 target:self action:@selector(update_Clicked:)];
	UIBarButtonItem *addButton = [[UIBarButtonItem alloc] 
								  initWithBarButtonSystemItem:UIBarButtonSystemItemAdd 
								  target:self action:@selector(add_Clicked:)];
	
	
    self.navigationItem.rightBarButtonItem = addButton;
    [addButton release];
	
	self.dateFormatter = [[[NSDateFormatter alloc] init] autorelease];
	[self.dateFormatter setDateStyle:NSDateFormatterShortStyle];
	
	
	priorityAscending = NO;
	dateAscending = YES;
	nameAscending = YES;
}

- (void) add_Clicked:(id)sender {
	
	if(addController == nil) {
		addController = [[AddToDoItemViewController alloc] initWithNibName:@"AddToDoItemViewController" bundle:nil];
	}
		
	if(addNavigationController == nil) {
		addNavigationController = [[UINavigationController alloc] initWithRootViewController:addController];
	}
	
	[self.navigationController presentModalViewController:addNavigationController animated:YES];
}

- (void) update_Clicked:(id)sender {
	NSIndexPath* path = [self.tableView indexPathForSelectedRow];
	if (path != nil && path.row >= 0) {
		ToDoItem* todoItem = [todoItemsArray objectAtIndex:path.row];
		if(addController == nil) {
			addController = [[AddToDoItemViewController alloc] initWithNibName:@"AddToDoItemViewController" bundle:nil];
		}
		[addController setTodoItem:todoItem];
		if(addNavigationController == nil) {
			addNavigationController = [[UINavigationController alloc] initWithRootViewController:addController];
		}
		[self.navigationController presentModalViewController:addNavigationController animated:YES];
	}
}

- (void) delete_Clicked:(id)sender {
	NSIndexPath* path = [self.tableView indexPathForSelectedRow];
	if (path != nil && path.row >= 0) {
		ToDoItem* todoItem = [todoItemsArray objectAtIndex:path.row];
		
		[todoItemsArray removeObject:todoItem];	
		[managedObjectContext deleteObject:todoItem];
		NSError* error;
		if (![managedObjectContext save:&error]) {
		}
		
		
		[self.tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:path] withRowAnimation:UITableViewRowAnimationFade];
		
		//Selektion zuruecksetzen
		[self.tableView deselectRowAtIndexPath:path animated:NO];
		[path release];
	}
	[[UIApplication sharedApplication] setApplicationIconBadgeNumber:[todoItemsArray count]];	
}


- (void)viewWillAppear:(BOOL)animated {
	[super viewWillAppear:animated];
	NSError *error;
	NSFetchRequest *request = [[NSFetchRequest alloc] init];
	NSEntityDescription *entity = [NSEntityDescription entityForName:@"ToDoItem" inManagedObjectContext:managedObjectContext];
	[request setEntity:entity];
	
	NSSortDescriptor *sortDescriptor = [[NSSortDescriptor alloc] initWithKey:@"priority" ascending:YES];
	NSArray *sortDescriptors = [[NSArray alloc] initWithObjects:sortDescriptor, nil];
	[request setSortDescriptors:sortDescriptors];
	
	
	NSMutableArray *mutableFetchResults = [[managedObjectContext executeFetchRequest:request error:&error] mutableCopy];
	if (mutableFetchResults == nil) {
		NSLog(@"Fehler beim Laden der Daten");
	}
	[self setTodoItemsArray:mutableFetchResults];
	[mutableFetchResults release];
	[sortDescriptor release];
	[sortDescriptors release];
	
	
	[toolbar sizeToFit];
	CGFloat toolbarHeight = [toolbar frame].size.height;
	CGRect rootViewBounds = self.parentViewController.view.bounds;
	CGFloat rootViewHeight = CGRectGetHeight(rootViewBounds);
	CGFloat rootViewWidth = CGRectGetWidth(rootViewBounds);
	CGRect rectArea = CGRectMake(0, rootViewHeight - toolbarHeight, rootViewWidth, toolbarHeight);
	[toolbar setFrame:rectArea];
	[self.navigationController.view addSubview:toolbar];
	[[UIApplication sharedApplication] setApplicationIconBadgeNumber:[todoItemsArray count]];
}


- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
	[self becomeFirstResponder];
	[self.tableView reloadData];
	
}
/*
- (void)viewWillDisappear:(BOOL)animated {
	[super viewWillDisappear:animated];
}
*/
/*
- (void)viewDidDisappear:(BOOL)animated {
	[super viewDidDisappear:animated];
}
*/


 // Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
	return YES;
}


- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release anything that can be recreated in viewDidLoad or on demand.
	// e.g. self.myOutlet = nil;
}

#pragma mark -
#pragma mark Sortierung

- (IBAction)sortByDate:(id)sender {
	[self sortTableView:@"until" ascending:dateAscending];
	
	dateAscending = !dateAscending;
	priorityAscending = YES;
	nameAscending = YES;
}

- (IBAction)sortByPriority:(id)sender {
	[self sortTableView:@"priority" ascending:priorityAscending];
	
	priorityAscending = !priorityAscending;
	dateAscending = YES;
	nameAscending = YES;
	
}

- (IBAction)sortByShortDesc:(id)sender {
	[self sortTableView:@"shortDesc" ascending:nameAscending];
	
	nameAscending = !nameAscending;
	dateAscending = YES;
	priorityAscending = YES;
}

- (void) sortTableView:(NSString*)descriptor ascending:(Boolean)ascending {
	NSError *error;
	NSFetchRequest *request = [[NSFetchRequest alloc] init];
	NSEntityDescription *entity = [NSEntityDescription entityForName:@"ToDoItem" inManagedObjectContext:managedObjectContext];
	[request setEntity:entity];
	
	NSSortDescriptor *sortDescriptor = [[NSSortDescriptor alloc] initWithKey:descriptor ascending:ascending];
	NSArray *sortDescriptors = [[NSArray alloc] initWithObjects:sortDescriptor, nil];
	[request setSortDescriptors:sortDescriptors];
	
	
	NSMutableArray *mutableFetchResults = [[managedObjectContext executeFetchRequest:request error:&error] mutableCopy];
	if (mutableFetchResults == nil) {
		// Handle the error.
	}
	[self setTodoItemsArray:mutableFetchResults];
	[self.tableView reloadData];
	
	//Allokierte Objekte aufraeumen
	[request release];
	[sortDescriptor release];
	[sortDescriptors release];
	[mutableFetchResults release];
}

#pragma mark -
#pragma mark Table view methods

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
	return [todoItemsArray count];
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
	static NSString *CellIdentifier = @"ToDoItemCell";
	
	cell = (ToDoItemCell*) [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
	if (cell == nil) {
		[[NSBundle mainBundle] loadNibNamed:@"ToDoItemCell" owner:self options:nil];
	}
	
	//Get the object from the array.
	ToDoItem *todoItem = [todoItemsArray objectAtIndex:indexPath.row];
	
	int priority=[todoItem.priority intValue];
	cell.titleLabel.text =todoItem.shortDesc;
	cell.priorityLabel.text = [NSString stringWithFormat:@"%d", priority];
	cell.dateLabel.text = [self.dateFormatter stringFromDate:todoItem.until];
	
	// Setzten der Farbe fuer das Feld Prioritaet
	switch (priority) {
		case 1:
			cell.priorityLabel.backgroundColor= [UIColor redColor];
			break;
		case 2:
			cell.priorityLabel.backgroundColor= [UIColor yellowColor];
			break;
		default:
			cell.priorityLabel.backgroundColor= [UIColor greenColor];
			break;
	}
	return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    // Navigation logic may go here -- for example, create and push another view controller.
	// AnotherViewController *anotherViewController = [[AnotherViewController alloc] initWithNibName:@"AnotherView" bundle:nil];
    // NSManagedObject *selectedObject = [[self fetchedResultsController] objectAtIndexPath:indexPath];
    // Pass the selected object to the new view controller.
    /// ...
	// [self.navigationController pushViewController:anotherViewController animated:YES];
	// [anotherViewController release];
}


/*
// Override to support conditional editing of the table view.
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the specified item to be editable.
    return YES;
}
*/


// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        // Delete the managed object for the given index path
		NSManagedObjectContext *context = [fetchedResultsController managedObjectContext];
		[context deleteObject:[fetchedResultsController objectAtIndexPath:indexPath]];
		
		// Save the context.
		NSError *error;
		if (![context save:&error]) {
			// Handle the error...
		}
		
		[tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }   
}


- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
    // The table view should not be re-orderable.
    return NO;
}


/*
// NSFetchedResultsControllerDelegate method to notify the delegate that all section and object changes have been processed. 
- (void)controllerDidChangeContent:(NSFetchedResultsController *)controller {
	[self.tableView reloadData];
}
*/


- (void)dealloc {
	[fetchedResultsController release];
	[managedObjectContext release];
	
	[addController release];
	[addNavigationController release];
	
    [super dealloc];
}

#pragma mark Motion Handling

- (BOOL) canBecomeFirstResponder {
    return YES;
}

- (void)motionEnded:(UIEventSubtype)motion withEvent:(UIEvent *)event {
	[self delete_Clicked:nil];
}


@end

