/********************************************************************
 * $Id: SmartLibraryService.java 80 2009-10-02 18:40:57Z rvandenh $
 *
 * (c) Copyright 2009 TH Wildau
 * All rights reserved
 ********************************************************************/
package de.thwildau.tm.library.service;

import java.util.List;

import de.thwildau.tm.library.api.Book;
import de.thwildau.tm.library.api.ILibraryService;
import de.thwildau.tm.library.util.BookSorter;
 

/**
 * Smart service class that does the book sorting on the client side.
 * Everything else is taken from the remote service.
 * @author Ralf Vandenhouten
 * @version $Revision: 80 $
 */
public abstract class SmartLibraryService implements ILibraryService 
{
    /**
     * Here we use the class BookSorter that is not even known on the client side.
     * It is transferred using type injection.
     * Note that this client-side smart method is allowed to call the remote method
     * getBookList().
     */
    public List<Book> getSortedBookList() {
        BookSorter sorter = new BookSorter(getBookList()); 
        return sorter.getSortedList();
    }
}
