/********************************************************************
 * $Id: BookSorter.java 80 2009-10-02 18:40:57Z rvandenh $
 *
 * (c) Copyright 2009 TH Wildau
 * All rights reserved
 ********************************************************************/
package de.thwildau.tm.library.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import de.thwildau.tm.library.api.Book;


/**
 * This class that helps sorting a list of {@link Book}s.
 * @author Ralf Vandenhouten
 * @version $Revision: 80 $
 */
public class BookSorter {
    
    private List<Book> list;
    
    /**
     * Constructor of {@link BookSorter}
     * @param list - the book list to be sorted
      */
    public BookSorter(List<Book> list) {
        this.list = list;
    }
    
    /**
     * Creates a copy of the given book list sorted by author
     * @return the sorted list of books
     */
    public List<Book> getSortedList() {
        System.out.print("BookSorter executing...   ");
        List<Book> cloneList = new ArrayList<Book>(list);
        Collections.sort(cloneList, new Comparator<Book>() {
            public int compare(Book a, Book b) {
                return a.getAuthor().compareTo(b.getAuthor());
            }
        });
        System.out.println("finished.");
        return cloneList;
    }
}
