/********************************************************************
 * $Id: Book.java 80 2009-10-02 18:40:57Z rvandenh $
 *
 * (c) Copyright 2009 TH Wildau
 * All rights reserved
 ********************************************************************/
package de.thwildau.tm.library.api;

import java.io.Serializable;
 

/**
 * This class contains the book details.
 * @author Ralf Vandenhouten
 * @version $Revision: 80 $
 */
public class Book implements Serializable {
    
    private static final long serialVersionUID = 2479321240339577919L;

    private long id;
    private String author;
    private String title;
    private String publisher;
    private int year;
    private String isbn;
    
    /**
     * Constructor
     * @param id - the unique ID of the book
     * @param author - the author of the book
     * @param title - the title of the book
     * @param publisher - the publisher of the book
     * @param year - the release year of the book
     * @param isbn - the ISBN
     */
    public Book(long id, String author, String title, 
            String publisher, int year, String isbn) 
    {
        this.id = id;
        this.isbn = isbn;
        this.author = author;
        this.title = title;
        this.publisher = publisher;
        this.year = year;
    }
    
    /**
     * @return the field id.
     */
    public long getId() {
        return id;
    }

    /**
     * @return the field isbn.
     */
    public String getIsbn() {
        return isbn;
    }
    
    /**
     * @return the field author.
     */
    public String getAuthor() {
        return author;
    }
    
    /**
     * @return the field title.
     */
    public String getTitle() {
        return title;
    }
    
    /**
     * @return the field publisher.
     */
    public String getPublisher() {
        return publisher;
    }
    
    /**
     * @return the field year.
     */
    public int getYear() {
        return year;
    }
    
    public String toString() {
        return author + ": " + title + "; " + publisher + ", " + year + ".";
    }
}
